/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.jelly.util.CommandLineParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Jelly {
    private static final Log log = LogFactory.getLog(Jelly.class);
    private JellyContext context;
    private URL url;
    private URL rootContext;
    private boolean loadedProperties = false;
    private String defaultNamespaceURI = null;
    private boolean validateXML = false;

    public static void main(String[] args) throws Exception {
        try {
            if (args.length <= 0) {
                System.out.println("Usage: jelly [scriptFile] [-script scriptFile -o outputFile -Dsysprop=syspropval]");
                return;
            }
            CommandLineParser.getInstance().invokeCommandLineJelly(args);
        }
        catch (JellyException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                e.printStackTrace();
            }
            cause.printStackTrace();
        }
    }

    public static String getJellyVersion() {
        return Jelly.readBuildTimestampResource("jelly-version.txt");
    }

    public static String getJellyBuildDate() {
        return Jelly.readBuildTimestampResource("jelly-build-date.txt");
    }

    private static String readBuildTimestampResource(String name) {
        Reader in = null;
        try {
            int r;
            StringWriter w = new StringWriter();
            in = new InputStreamReader(Jelly.class.getResourceAsStream(name), "utf-8");
            while ((r = in.read()) >= 0) {
                w.write((char)r);
            }
            return w.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException("Resource \"" + name + "\" not found.");
        }
    }

    public Script compileScript() throws JellyException {
        if (!this.loadedProperties) {
            this.loadedProperties = true;
            this.loadJellyProperties();
        }
        XMLParser parser = new XMLParser();
        try {
            parser.setContext(this.getJellyContext());
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        Script script = null;
        try {
            parser.setDefaultNamespaceURI(this.defaultNamespaceURI);
            parser.setValidating(this.validateXML);
            script = parser.parse(this.getUrl());
            script = script.compile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiled script: " + this.getUrl()));
            }
        }
        catch (IOException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        catch (SAXException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        return script;
    }

    public void setScript(String script) throws MalformedURLException {
        this.setUrl(this.resolveURL(script));
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getRootContext() throws MalformedURLException {
        if (this.rootContext == null) {
            this.rootContext = new File(System.getProperty("user.dir")).toURL();
        }
        return this.rootContext;
    }

    public void setRootContext(URL rootContext) {
        this.rootContext = rootContext;
    }

    public JellyContext getJellyContext() throws MalformedURLException {
        if (this.context == null) {
            String text = this.getUrl().toString();
            int idx = text.lastIndexOf(47);
            text = text.substring(0, idx + 1);
            this.context = new JellyContext(this.getRootContext(), new URL(text));
        }
        return this.context;
    }

    public void setDefaultNamespaceURI(String namespace) {
        this.defaultNamespaceURI = namespace;
    }

    public void setValidateXML(boolean validate) {
        this.validateXML = validate;
    }

    protected URL resolveURL(String name) throws MalformedURLException {
        URL resourceUrl = ClassLoaderUtils.getClassLoader(this.getClass()).getResource(name);
        if (resourceUrl == null) {
            File file = new File(name);
            if (file.exists()) {
                return file.toURL();
            }
            return new URL(name);
        }
        return resourceUrl;
    }

    protected void loadJellyProperties() {
        InputStream is = null;
        String userDir = System.getProperty("user.home");
        File f = new File(userDir + File.separator + "jelly.properties");
        this.loadProperties(f);
        f = new File("jelly.properties");
        this.loadProperties(f);
        is = ClassLoaderUtils.getClassLoader(this.getClass()).getResourceAsStream("jelly.properties");
        if (is != null) {
            try {
                this.loadProperties(is);
            }
            catch (Exception e) {
                log.error((Object)("Caught exception while loading jelly.properties from the classpath. Reason: " + e), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(File f) {
        InputStream is = null;
        try {
            if (f.exists()) {
                is = new FileInputStream(f);
                this.loadProperties(is);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while loading: " + f.getName() + ". Reason: " + e), (Throwable)e);
        }
        finally {
            block14: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)"error closing property input stream", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void loadProperties(InputStream is) throws IOException {
        JellyContext theContext = this.getJellyContext();
        Properties props = new Properties();
        props.load(is);
        Enumeration<?> propsEnum = props.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            String value = props.getProperty(key);
            theContext.setVariable(key, value);
        }
    }
}

