/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.jelly.DynaBeanTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.Attribute;
import org.apache.commons.jelly.impl.BeanSource;

public class DynamicDynaBeanTag
extends DynaBeanTagSupport
implements BeanSource {
    private DynaClass beanClass;
    private String variableNameAttribute;
    private String var;
    private Set setAttributesSet = new HashSet();
    private Map attributes;

    public DynamicDynaBeanTag(DynaClass beanClass, Map attributes, String variableNameAttribute) {
        this.beanClass = beanClass;
        this.attributes = attributes;
        this.variableNameAttribute = variableNameAttribute;
    }

    public void beforeSetAttributes() throws JellyTagException {
        try {
            this.setDynaBean(this.beanClass.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException("Could not instantiate dynabean", e);
        }
        catch (InstantiationException e) {
            throw new JellyTagException("Could not instantiate dynabean", e);
        }
        this.setAttributesSet.clear();
    }

    public void setAttribute(String name, Object value) throws JellyTagException {
        boolean isVariableName = false;
        if (this.variableNameAttribute != null && this.variableNameAttribute.equals(name)) {
            this.var = value == null ? null : value.toString();
            isVariableName = true;
        }
        if (!isVariableName) {
            this.setAttributesSet.add(name);
            super.setAttribute(name, value);
        }
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        for (Attribute attribute : this.attributes.values()) {
            String name = attribute.getName();
            if (this.setAttributesSet.contains(name)) continue;
            if (attribute.isRequired()) {
                throw new MissingAttributeException(name);
            }
            Object value = null;
            Expression expression = attribute.getDefaultValue();
            if (expression != null) {
                value = expression.evaluate(this.context);
            }
            if (value == null) continue;
            super.setAttribute(name, value);
        }
        this.invokeBody(output);
        if (this.var != null) {
            this.context.setVariable(this.var, this.getDynaBean());
        }
    }

    public Object getBean() {
        return this.getDynaBean();
    }
}

