/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.ExceptionHandler;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathFunctionNotFoundException;
import org.apache.commons.jxpath.JXPathInvalidSyntaxException;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.JXPathCompiledExpression;
import org.apache.commons.jxpath.ri.NamespaceResolver;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.RootContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.VariablePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.BeanPointerFactory;
import org.apache.commons.jxpath.ri.model.beans.CollectionPointerFactory;
import org.apache.commons.jxpath.ri.model.container.ContainerPointerFactory;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPointerFactory;
import org.apache.commons.jxpath.util.ClassLoaderUtil;
import org.apache.commons.jxpath.util.ReverseComparator;
import org.apache.commons.jxpath.util.TypeUtils;

public class JXPathContextReferenceImpl
extends JXPathContext {
    public static final boolean USE_SOFT_CACHE = true;
    private static final Compiler COMPILER;
    private static Map<String, Object> compiled;
    private static int cleanupCount;
    private static NodePointerFactory[] nodeFactoryArray;
    private static final int CLEANUP_THRESHOLD = 500;
    private static final Vector<NodePointerFactory> nodeFactories;
    protected NamespaceResolver namespaceResolver;
    private Pointer rootPointer;
    private Pointer contextPointer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodePointerFactory(NodePointerFactory factory) {
        Vector<NodePointerFactory> vector = nodeFactories;
        synchronized (vector) {
            nodeFactories.add(factory);
            nodeFactoryArray = null;
        }
    }

    public static Object allocateConditionally(String className, String existenceCheckClassName) {
        try {
            try {
                ClassLoaderUtil.getClass(existenceCheckClassName, true);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
            return ClassLoaderUtil.getClass(className, true).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot allocate " + className, ex);
        }
    }

    private static synchronized void createNodeFactoryArray() {
        if (nodeFactoryArray == null) {
            nodeFactoryArray = nodeFactories.toArray(new NodePointerFactory[nodeFactories.size()]);
            Arrays.sort(nodeFactoryArray, (a, b) -> {
                int orderA = a.getOrder();
                int orderB = b.getOrder();
                return orderA - orderB;
            });
        }
    }

    public static NodePointerFactory[] getNodePointerFactories() {
        return nodeFactoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeNodePointerFactory(NodePointerFactory factory) {
        Vector<NodePointerFactory> vector = nodeFactories;
        synchronized (vector) {
            boolean remove = nodeFactories.remove(factory);
            nodeFactoryArray = null;
            return remove;
        }
    }

    protected JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean) {
        this(parentContext, contextBean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean, Pointer contextPointer) {
        super(parentContext, contextBean);
        Vector<NodePointerFactory> vector = nodeFactories;
        synchronized (vector) {
            JXPathContextReferenceImpl.createNodeFactoryArray();
        }
        if (contextPointer != null) {
            this.contextPointer = contextPointer;
            this.rootPointer = NodePointer.newNodePointer(new QName(null, "root"), contextPointer.getRootNode(), this.getLocale());
        } else {
            this.rootPointer = this.contextPointer = NodePointer.newNodePointer(new QName(null, "root"), contextBean, this.getLocale());
        }
        NamespaceResolver parentNR = null;
        if (parentContext instanceof JXPathContextReferenceImpl) {
            parentNR = ((JXPathContextReferenceImpl)parentContext).getNamespaceResolver();
        }
        this.namespaceResolver = new NamespaceResolver(parentNR);
        this.namespaceResolver.setNamespaceContextPointer((NodePointer)this.contextPointer);
    }

    private void checkSimplePath(Expression expr) {
        if (!(expr instanceof LocationPath) || !((LocationPath)expr).isSimplePath()) {
            throw new JXPathInvalidSyntaxException("JXPath can only create a path if it uses exclusively the child:: and attribute:: axes and has no context-dependent predicates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression compileExpression(String xpath) {
        Expression expr;
        Map<String, Object> map = compiled;
        synchronized (map) {
            expr = null;
            SoftReference ref = (SoftReference)compiled.get(xpath);
            if (ref != null) {
                expr = (Expression)ref.get();
            }
        }
        if (expr != null) {
            return expr;
        }
        expr = (Expression)Parser.parseExpression(xpath, this.getCompiler());
        map = compiled;
        synchronized (map) {
            if (cleanupCount++ >= 500) {
                Iterator<Map.Entry<String, Object>> it = compiled.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Object> me = it.next();
                    if (((SoftReference)me.getValue()).get() != null) continue;
                    it.remove();
                }
                cleanupCount = 0;
            }
            compiled.put(xpath, new SoftReference<Expression>(expr));
        }
        return expr;
    }

    @Override
    protected CompiledExpression compilePath(String xpath) {
        return new JXPathCompiledExpression(xpath, this.compileExpression(xpath));
    }

    @Override
    public Pointer createPath(String xpath) {
        return this.createPath(xpath, this.compileExpression(xpath));
    }

    public Pointer createPath(String xpath, Expression expr) {
        try {
            Pointer pointer;
            Object result = expr.computeValue(this.getEvalContext());
            if (result instanceof Pointer) {
                pointer = (Pointer)result;
            } else if (result instanceof EvalContext) {
                EvalContext ctx = (EvalContext)result;
                pointer = ctx.getSingleNodePointer();
            } else {
                this.checkSimplePath(expr);
                throw new JXPathException("Cannot create path:" + xpath);
            }
            return ((NodePointer)pointer).createPath(this);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create XPath " + xpath, ex);
        }
    }

    public Pointer createPathAndSetValue(String xpath, Expression expr, Object value) {
        try {
            return this.setValue(xpath, expr, value, true);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create XPath " + xpath, ex);
        }
    }

    @Override
    public Pointer createPathAndSetValue(String xpath, Object value) {
        return this.createPathAndSetValue(xpath, this.compileExpression(xpath), value);
    }

    public EvalContext getAbsoluteRootContext() {
        return new InitialContext(new RootContext(this, this.getAbsoluteRootPointer()));
    }

    private NodePointer getAbsoluteRootPointer() {
        return (NodePointer)this.rootPointer;
    }

    protected Compiler getCompiler() {
        return COMPILER;
    }

    @Override
    public Pointer getContextPointer() {
        return this.contextPointer;
    }

    private EvalContext getEvalContext() {
        return new InitialContext(new RootContext(this, (NodePointer)this.getContextPointer()));
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        String namespace = functionName.getPrefix();
        String name = functionName.getName();
        for (JXPathContext funcCtx = this; funcCtx != null; funcCtx = funcCtx.getParentContext()) {
            Function func;
            Functions funcs = funcCtx.getFunctions();
            if (funcs == null || (func = funcs.getFunction(namespace, name, parameters)) == null) continue;
            return func;
        }
        throw new JXPathFunctionNotFoundException("Undefined function: " + functionName.toString());
    }

    @Override
    public Pointer getNamespaceContextPointer() {
        return this.namespaceResolver.getNamespaceContextPointer();
    }

    public NamespaceResolver getNamespaceResolver() {
        this.namespaceResolver.seal();
        return this.namespaceResolver;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceResolver.getNamespaceURI(prefix);
    }

    @Override
    public Pointer getPointer(String xpath) {
        return this.getPointer(xpath, this.compileExpression(xpath));
    }

    public Pointer getPointer(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getEvalContext());
        if (result instanceof EvalContext) {
            result = ((EvalContext)result).getSingleNodePointer();
        }
        if (result instanceof Pointer) {
            if (!this.isLenient() && !((NodePointer)result).isActual()) {
                throw new JXPathNotFoundException("No pointer for xpath: " + xpath);
            }
            return (Pointer)result;
        }
        return NodePointer.newNodePointer(null, result, this.getLocale());
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaceResolver.getPrefix(namespaceURI);
    }

    @Override
    public JXPathContext getRelativeContext(Pointer pointer) {
        Object contextBean = pointer.getNode();
        if (contextBean == null) {
            throw new JXPathException("Cannot create a relative context for a non-existent node: " + pointer);
        }
        return new JXPathContextReferenceImpl(this, contextBean, pointer);
    }

    @Override
    public Object getValue(String xpath) {
        Expression expression = this.compileExpression(xpath);
        return this.getValue(xpath, expression);
    }

    @Override
    public Object getValue(String xpath, Class requiredType) {
        Expression expr = this.compileExpression(xpath);
        return this.getValue(xpath, expr, requiredType);
    }

    public Object getValue(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getEvalContext());
        if (result == null) {
            if (expr instanceof Path && !this.isLenient()) {
                throw new JXPathNotFoundException("No value for xpath: " + xpath);
            }
            return null;
        }
        if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            result = ctx.getSingleNodePointer();
            if (!this.isLenient() && result == null) {
                throw new JXPathNotFoundException("No value for xpath: " + xpath);
            }
        }
        if (result instanceof NodePointer) {
            result = ((NodePointer)result).getValuePointer();
            if (!this.isLenient()) {
                NodePointer.verify((NodePointer)result);
            }
            result = ((NodePointer)result).getValue();
        }
        return result;
    }

    public Object getValue(String xpath, Expression expr, Class requiredType) {
        Object value = this.getValue(xpath, expr);
        if (value != null && requiredType != null) {
            if (!TypeUtils.canConvert(value, requiredType)) {
                throw new JXPathTypeConversionException("Invalid expression type. '" + xpath + "' returns " + value.getClass().getName() + ". It cannot be converted to " + requiredType.getName());
            }
            value = TypeUtils.convert(value, requiredType);
        }
        return value;
    }

    public NodePointer getVariablePointer(QName qName) {
        return NodePointer.newNodePointer(qName, VariablePointerFactory.contextWrapper(this), this.getLocale());
    }

    public Iterator iterate(String xpath) {
        return this.iterate(xpath, this.compileExpression(xpath));
    }

    public Iterator iterate(String xpath, Expression expr) {
        return expr.iterate(this.getEvalContext());
    }

    @Override
    public Iterator<Pointer> iteratePointers(String xpath) {
        return this.iteratePointers(xpath, this.compileExpression(xpath));
    }

    public Iterator<Pointer> iteratePointers(String xpath, Expression expr) {
        return expr.iteratePointers(this.getEvalContext());
    }

    @Override
    public void registerNamespace(String prefix, String namespaceURI) {
        if (this.namespaceResolver.isSealed()) {
            this.namespaceResolver = (NamespaceResolver)this.namespaceResolver.clone();
        }
        this.namespaceResolver.registerNamespace(prefix, namespaceURI);
    }

    @Override
    public void removeAll(String xpath) {
        this.removeAll(xpath, this.compileExpression(xpath));
    }

    public void removeAll(String xpath, Expression expr) {
        try {
            ArrayList<NodePointer> list = new ArrayList<NodePointer>();
            Iterator it = expr.iteratePointers(this.getEvalContext());
            while (it.hasNext()) {
                list.add((NodePointer)it.next());
            }
            Collections.sort(list, ReverseComparator.INSTANCE);
            it = list.iterator();
            if (it.hasNext()) {
                NodePointer pointer = (NodePointer)it.next();
                pointer.remove();
                while (it.hasNext()) {
                    this.removePath(((NodePointer)it.next()).asPath());
                }
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove all for xpath " + xpath, ex);
        }
    }

    @Override
    public void removePath(String xpath) {
        this.removePath(xpath, this.compileExpression(xpath));
    }

    public void removePath(String xpath, Expression expr) {
        try {
            NodePointer pointer = (NodePointer)this.getPointer(xpath, expr);
            if (pointer != null) {
                pointer.remove();
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove XPath " + xpath, ex);
        }
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (this.rootPointer instanceof NodePointer) {
            ((NodePointer)this.rootPointer).setExceptionHandler(exceptionHandler);
        }
    }

    @Override
    public void setNamespaceContextPointer(Pointer pointer) {
        if (this.namespaceResolver.isSealed()) {
            this.namespaceResolver = (NamespaceResolver)this.namespaceResolver.clone();
        }
        this.namespaceResolver.setNamespaceContextPointer((NodePointer)pointer);
    }

    public void setValue(String xpath, Expression expr, Object value) {
        try {
            this.setValue(xpath, expr, value, false);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to set value with XPath " + xpath, ex);
        }
    }

    private Pointer setValue(String xpath, Expression expr, Object value, boolean create) {
        Pointer pointer;
        Object result = expr.computeValue(this.getEvalContext());
        if (result instanceof Pointer) {
            pointer = (Pointer)result;
        } else if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            pointer = ctx.getSingleNodePointer();
        } else {
            if (create) {
                this.checkSimplePath(expr);
            }
            throw new JXPathException("Cannot set value for xpath: " + xpath);
        }
        if (create) {
            pointer = ((NodePointer)pointer).createPath(this, value);
        } else {
            pointer.setValue(value);
        }
        return pointer;
    }

    @Override
    public void setValue(String xpath, Object value) {
        this.setValue(xpath, this.compileExpression(xpath), value);
    }

    static {
        NodePointerFactory dynaBeanFactory;
        NodePointerFactory jdomFactory;
        COMPILER = new TreeCompiler();
        compiled = new HashMap<String, Object>();
        nodeFactories = new Vector();
        nodeFactories.add(new CollectionPointerFactory());
        nodeFactories.add(new BeanPointerFactory());
        nodeFactories.add(new DynamicPointerFactory());
        nodeFactories.add(new VariablePointerFactory());
        NodePointerFactory domFactory = (NodePointerFactory)JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.dom.DOMPointerFactory", "org.w3c.dom.Node");
        if (domFactory != null) {
            nodeFactories.add(domFactory);
        }
        if ((jdomFactory = (NodePointerFactory)JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.jdom.JDOMPointerFactory", "org.jdom.Document")) != null) {
            nodeFactories.add(jdomFactory);
        }
        if ((dynaBeanFactory = (NodePointerFactory)JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanPointerFactory", "org.apache.commons.beanutils.DynaBean")) != null) {
            nodeFactories.add(dynaBeanFactory);
        }
        nodeFactories.add(new ContainerPointerFactory());
        JXPathContextReferenceImpl.createNodeFactoryArray();
    }
}

