/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.function.TriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TriConsumerTest
extends AbstractLangTest {
    TriConsumerTest() {
    }

    @Test
    void testAccept() throws Throwable {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        TriConsumer tri = (t, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
        };
        tri.accept(ref1, ref2, ref3);
        Assertions.assertEquals((Character)Character.valueOf('a'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)1, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"z", ref3.get());
    }

    @Test
    void testAndThen() throws Throwable {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        TriConsumer tri = (t, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
        };
        TriConsumer triAfter = (t, u, v) -> {
            ref1.set(Character.valueOf('b'));
            ref2.set((short)2);
            ref3.set("zz");
        };
        tri.andThen(triAfter).accept(ref1, ref2, ref3);
        Assertions.assertEquals((Character)Character.valueOf('b'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)2, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"zz", ref3.get());
    }
}

