/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.fraction.FractionField;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SparseFieldVector;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldLUSolverTest {
    private int[][] testData = new int[][]{{1, 2, 3}, {2, 5, 3}, {1, 0, 8}};
    private int[][] luData = new int[][]{{2, 3, 3}, {0, 5, 7}, {6, 9, 8}};
    private int[][] singular = new int[][]{{2, 3}, {2, 3}};
    private int[][] bigSingular = new int[][]{{1, 2, 3, 4}, {2, 5, 3, 4}, {7, 3, 256, 1930}, {3, 7, 6, 8}};

    public static FieldMatrix<Fraction> createFractionMatrix(int[][] data) {
        int numRows = data.length;
        int numCols = data[0].length;
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                m.setEntry(i, j, (FieldElement)new Fraction(data[i][j], 1));
            }
        }
        return m;
    }

    @Test
    public void testSingular() {
        FieldDecompositionSolver solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.testData)).getSolver();
        Assert.assertTrue((boolean)solver.isNonSingular());
        solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.singular)).getSolver();
        Assert.assertFalse((boolean)solver.isNonSingular());
        solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.bigSingular)).getSolver();
        Assert.assertFalse((boolean)solver.isNonSingular());
    }

    @Test
    public void testSolveDimensionErrors() {
        FieldDecompositionSolver solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.testData)).getSolver();
        FieldMatrix<Fraction> b = FieldLUSolverTest.createFractionMatrix(new int[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolveSingularityErrors() {
        FieldDecompositionSolver solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.singular)).getSolver();
        FieldMatrix<Fraction> b = FieldLUSolverTest.createFractionMatrix(new int[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testSolve() {
        int j;
        FieldDecompositionSolver solver = new FieldLUDecomposition(FieldLUSolverTest.createFractionMatrix(this.testData)).getSolver();
        FieldMatrix<Fraction> b = FieldLUSolverTest.createFractionMatrix(new int[][]{{1, 0}, {2, -5}, {3, 1}});
        FieldMatrix<Fraction> xRef = FieldLUSolverTest.createFractionMatrix(new int[][]{{19, -71}, {-6, 22}, {-2, 9}});
        FieldMatrix x = solver.solve(b);
        for (int i = 0; i < x.getRowDimension(); ++i) {
            for (int j2 = 0; j2 < x.getColumnDimension(); ++j2) {
                Assert.assertEquals((String)("(" + i + ", " + j2 + ")"), (Object)xRef.getEntry(i, j2), (Object)x.getEntry(i, j2));
            }
        }
        for (j = 0; j < b.getColumnDimension(); ++j) {
            FieldVector xj = solver.solve(b.getColumnVector(j));
            for (int i = 0; i < xj.getDimension(); ++i) {
                Assert.assertEquals((String)("(" + i + ", " + j + ")"), (Object)xRef.getEntry(i, j), (Object)xj.getEntry(i));
            }
        }
        for (j = 0; j < b.getColumnDimension(); ++j) {
            SparseFieldVector bj = new SparseFieldVector((Field)FractionField.getInstance(), b.getColumn(j));
            FieldVector xj = solver.solve((FieldVector)bj);
            for (int i = 0; i < xj.getDimension(); ++i) {
                Assert.assertEquals((String)("(" + i + ", " + j + ")"), (Object)xRef.getEntry(i, j), (Object)xj.getEntry(i));
            }
        }
    }

    @Test
    public void testDeterminant() {
        Assert.assertEquals((double)-1.0, (double)this.getDeterminant(FieldLUSolverTest.createFractionMatrix(this.testData)), (double)1.0E-15);
        Assert.assertEquals((double)-10.0, (double)this.getDeterminant(FieldLUSolverTest.createFractionMatrix(this.luData)), (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)this.getDeterminant(FieldLUSolverTest.createFractionMatrix(this.singular)), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)this.getDeterminant(FieldLUSolverTest.createFractionMatrix(this.bigSingular)), (double)1.0E-15);
    }

    private double getDeterminant(FieldMatrix<Fraction> m) {
        return ((Fraction)new FieldLUDecomposition(m).getDeterminant()).doubleValue();
    }
}

