/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.VirtualFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.junit.Test;

public class ProviderCacheStrategyTests
extends AbstractProviderTestCase {
    public void assertContains(FileObject[] fos, String string) {
        for (FileObject fo : fos) {
            if (!string.equals(fo.getName().getBaseName())) continue;
            return;
        }
        ProviderCacheStrategyTests.fail((String)(string + " should be seen"));
    }

    public void assertContainsNot(FileObject[] fos, String string) {
        for (FileObject fo : fos) {
            if (!string.equals(fo.getName().getBaseName())) continue;
            ProviderCacheStrategyTests.fail((String)(string + " should not be seen"));
        }
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.GET_TYPE, Capability.LIST_CHILDREN};
    }

    @Test
    public void testManualCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf((FileObject)this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.MANUAL);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder((FileSystemManager)fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        cachedFolder.refresh();
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }

    @Test
    public void testOnCallCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf((FileObject)this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.ON_CALL);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder((FileSystemManager)fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }

    @Test
    public void testOnResolveCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf((FileObject)this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder((FileSystemManager)fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }
}

