/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.nio.file.AccessMode;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArraySorter;

public enum RandomAccessMode {
    READ(true, false){

        @Override
        public AccessMode[] toAccessModes() {
            return (AccessMode[])ACCESS_MODE_READ.clone();
        }
    }
    ,
    READWRITE(true, true){

        @Override
        public AccessMode[] toAccessModes() {
            return (AccessMode[])ACCESS_MODE_READ_WRITE.clone();
        }
    };

    private static final AccessMode[] ACCESS_MODE_READ;
    private static final AccessMode[] ACCESS_MODE_READ_WRITE;
    private final boolean read;
    private final boolean write;

    public static RandomAccessMode from(AccessMode ... accessModes) {
        Objects.requireNonNull(accessModes, "accessModes");
        if (accessModes.length == 0) {
            throw new IllegalArgumentException("Empty AccessMode[].");
        }
        AccessMode[] modes = (AccessMode[])ArraySorter.sort((Object[])((AccessMode[])accessModes.clone()));
        if (Arrays.binarySearch((Object[])modes, (Object)AccessMode.WRITE) >= 0) {
            return READWRITE;
        }
        if (Arrays.binarySearch((Object[])modes, (Object)AccessMode.READ) >= 0) {
            return READ;
        }
        throw new IllegalArgumentException(Arrays.toString((Object[])accessModes));
    }

    private RandomAccessMode(boolean read, boolean write) {
        this.read = read;
        this.write = write;
    }

    public String getModeString() {
        if (this.requestRead()) {
            if (this.requestWrite()) {
                return "rw";
            }
            return "r";
        }
        if (this.requestWrite()) {
            return "w";
        }
        return "";
    }

    public boolean requestRead() {
        return this.read;
    }

    public boolean requestWrite() {
        return this.write;
    }

    public AccessMode[] toAccessModes() {
        return null;
    }

    static {
        ACCESS_MODE_READ = new AccessMode[]{AccessMode.READ};
        ACCESS_MODE_READ_WRITE = new AccessMode[]{AccessMode.READ, AccessMode.WRITE};
    }
}

