/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.rest;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.CompressionUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.rest.RESTSecurityTokenService;
import org.apache.cxf.ws.security.sts.provider.SecurityTokenServiceImpl;
import org.apache.cxf.ws.security.sts.provider.model.ClaimsType;
import org.apache.cxf.ws.security.sts.provider.model.ObjectFactory;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.UseKeyType;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RESTSecurityTokenServiceImpl
extends SecurityTokenServiceImpl
implements RESTSecurityTokenService {
    public static final Map<String, String> DEFAULT_CLAIM_TYPE_MAP;
    public static final Map<String, String> DEFAULT_TOKEN_TYPE_MAP;
    private static final Map<String, String> DEFAULT_KEY_TYPE_MAP;
    private static final String CLAIM_TYPE = "ClaimType";
    private static final String CLAIM_TYPE_NS = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    private static final Logger LOG;
    @Context
    private MessageContext messageContext;
    @Context
    private javax.ws.rs.core.SecurityContext securityContext;
    private Map<String, String> claimTypeMap = DEFAULT_CLAIM_TYPE_MAP;
    private Map<String, String> tokenTypeMap = DEFAULT_TOKEN_TYPE_MAP;
    private String defaultKeyType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
    private List<String> defaultClaims;
    private boolean requestClaimsOptional = true;
    private boolean useDeflateEncoding = true;

    @Override
    public Response getXMLToken(String tokenType, String keyType, List<String> requestedClaims, String appliesTo, boolean wstrustResponse) {
        RequestSecurityTokenResponseType response = this.issueToken(tokenType, keyType, requestedClaims, appliesTo);
        if (wstrustResponse) {
            JAXBElement jaxbResponse = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponse(response);
            return Response.ok((Object)jaxbResponse).build();
        }
        RequestedSecurityTokenType requestedToken = this.getRequestedSecurityToken(response);
        return Response.ok((Object)requestedToken.getAny()).build();
    }

    @Override
    public Response getJSONToken(String tokenType, String keyType, List<String> requestedClaims, String appliesTo) {
        if (!"jwt".equals(tokenType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        RequestSecurityTokenResponseType response = this.issueToken(tokenType, keyType, requestedClaims, appliesTo);
        RequestedSecurityTokenType requestedToken = this.getRequestedSecurityToken(response);
        String token = ((Element)requestedToken.getAny()).getTextContent();
        return Response.ok((Object)new JSONWrapper(token)).build();
    }

    @Override
    public Response getPlainToken(String tokenType, String keyType, List<String> requestedClaims, String appliesTo) {
        RequestSecurityTokenResponseType response = this.issueToken(tokenType, keyType, requestedClaims, appliesTo);
        RequestedSecurityTokenType requestedToken = this.getRequestedSecurityToken(response);
        if ("jwt".equals(tokenType)) {
            return Response.ok((Object)((Element)requestedToken.getAny()).getTextContent()).build();
        }
        try {
            String encodedToken = this.encodeToken(DOM2Writer.nodeToString((Node)((Element)requestedToken.getAny())));
            return Response.ok((Object)encodedToken).build();
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private RequestedSecurityTokenType getRequestedSecurityToken(RequestSecurityTokenResponseType response) {
        for (Object obj : response.getAny()) {
            JAXBElement jaxbElement;
            if (!(obj instanceof JAXBElement) || !"RequestedSecurityToken".equals((jaxbElement = (JAXBElement)obj).getName().getLocalPart())) continue;
            return (RequestedSecurityTokenType)jaxbElement.getValue();
        }
        return null;
    }

    private RequestSecurityTokenResponseType issueToken(String tokenType, String keyType, List<String> requestedClaims, String appliesTo) {
        Document doc;
        X509Certificate clientCert;
        String keyTypeToUse;
        String tokenTypeToUse = tokenType;
        if (this.tokenTypeMap != null && this.tokenTypeMap.containsKey(tokenTypeToUse)) {
            tokenTypeToUse = this.tokenTypeMap.get(tokenTypeToUse);
        }
        if (DEFAULT_KEY_TYPE_MAP.containsKey(keyTypeToUse = keyType)) {
            keyTypeToUse = DEFAULT_KEY_TYPE_MAP.get(keyTypeToUse);
        }
        ObjectFactory of = new ObjectFactory();
        RequestSecurityTokenType request = of.createRequestSecurityTokenType();
        request.getAny().add(of.createTokenType(tokenTypeToUse));
        request.getAny().add(of.createRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue"));
        String desiredKeyType = keyTypeToUse != null ? keyTypeToUse : this.defaultKeyType;
        request.getAny().add(of.createKeyType(desiredKeyType));
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(desiredKeyType) && (clientCert = this.getTLSClientCertificate()) != null) {
            doc = DOMUtils.getEmptyDocument();
            Element keyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            try {
                X509Data certElem = new X509Data(doc);
                certElem.addCertificate(clientCert);
                keyInfoElement.appendChild(certElem.getElement());
                UseKeyType useKeyType = of.createUseKeyType();
                useKeyType.setAny((Object)keyInfoElement);
                JAXBElement useKey = of.createUseKey(useKeyType);
                request.getAny().add(useKey);
            }
            catch (XMLSecurityException ex) {
                LOG.warning(ex.getMessage());
            }
        }
        if (requestedClaims == null || requestedClaims.isEmpty()) {
            requestedClaims = this.defaultClaims;
        }
        if (requestedClaims != null && !requestedClaims.isEmpty()) {
            ClaimsType claimsType = of.createClaimsType();
            claimsType.setDialect(CLAIM_TYPE_NS);
            JAXBElement claims = of.createClaims(claimsType);
            for (String claim : requestedClaims) {
                if (this.claimTypeMap != null && this.claimTypeMap.containsKey(claim)) {
                    claim = this.claimTypeMap.get(claim);
                }
                Document doc2 = DOMUtils.createDocument();
                Element claimElement = doc2.createElementNS(CLAIM_TYPE_NS, CLAIM_TYPE);
                claimElement.setAttributeNS(null, "Uri", claim);
                claimElement.setAttributeNS(null, "Optional", Boolean.toString(this.requestClaimsOptional));
                claimsType.getAny().add(claimElement);
            }
            request.getAny().add(claims);
        }
        if (appliesTo != null) {
            String wspNamespace = "http://www.w3.org/ns/ws-policy";
            doc = DOMUtils.createDocument();
            Element appliesToElement = doc.createElementNS(wspNamespace, "AppliesTo");
            String addressingNamespace = "http://www.w3.org/2005/08/addressing";
            Element eprElement = doc.createElementNS(addressingNamespace, "EndpointReference");
            Element addressElement = doc.createElementNS(addressingNamespace, "Address");
            addressElement.setTextContent(appliesTo);
            eprElement.appendChild(addressElement);
            appliesToElement.appendChild(eprElement);
            request.getAny().add(appliesToElement);
        }
        return this.processRequest(RESTSecurityTokenService.Action.issue, request);
    }

    @Override
    public Response getToken(RESTSecurityTokenService.Action action, RequestSecurityTokenType request) {
        RequestSecurityTokenResponseType response = this.processRequest(action, request);
        JAXBElement jaxbResponse = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponse(response);
        return Response.ok((Object)jaxbResponse).build();
    }

    private RequestSecurityTokenResponseType processRequest(RESTSecurityTokenService.Action action, RequestSecurityTokenType request) {
        switch (action) {
            case validate: {
                return this.validate(request);
            }
            case renew: {
                return this.renew(request);
            }
            case cancel: {
                return this.cancel(request);
            }
        }
        return this.issueSingle(request);
    }

    @Override
    public Response removeToken(RequestSecurityTokenType request) {
        RequestSecurityTokenResponseType response = this.cancel(request);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response getKeyExchangeToken(RequestSecurityTokenType request) {
        RequestSecurityTokenResponseType response = this.keyExchangeToken(request);
        return Response.ok((Object)response).build();
    }

    public Map<String, String> getTokenTypeMap() {
        return this.tokenTypeMap;
    }

    public void setTokenTypeMap(Map<String, String> tokenTypeMap) {
        this.tokenTypeMap = tokenTypeMap;
    }

    public String getDefaultKeyType() {
        return this.defaultKeyType;
    }

    public void setDefaultKeyType(String defaultKeyType) {
        this.defaultKeyType = defaultKeyType;
    }

    public boolean isRequestClaimsOptional() {
        return this.requestClaimsOptional;
    }

    public void setRequestClaimsOptional(boolean requestClaimsOptional) {
        this.requestClaimsOptional = requestClaimsOptional;
    }

    public Map<String, String> getClaimTypeMap() {
        return this.claimTypeMap;
    }

    public void setClaimTypeMap(Map<String, String> claimTypeMap) {
        this.claimTypeMap = claimTypeMap;
    }

    protected Principal getPrincipal() {
        if (this.securityContext != null && this.securityContext.getUserPrincipal() != null) {
            return this.securityContext.getUserPrincipal();
        }
        SecurityContext sc = (SecurityContext)this.messageContext.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal();
        }
        X509Certificate clientCert = this.getTLSClientCertificate();
        if (clientCert != null) {
            return clientCert.getSubjectX500Principal();
        }
        return null;
    }

    private X509Certificate getTLSClientCertificate() {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)PhaseInterceptorChain.getCurrentMessage().get(TLSSessionInfo.class);
        if (tlsInfo != null && tlsInfo.getPeerCertificates() != null && tlsInfo.getPeerCertificates().length > 0 && tlsInfo.getPeerCertificates()[0] instanceof X509Certificate) {
            return (X509Certificate)tlsInfo.getPeerCertificates()[0];
        }
        return null;
    }

    protected Map<String, Object> getMessageContext() {
        return PhaseInterceptorChain.getCurrentMessage();
    }

    public void setUseDeflateEncoding(boolean deflate) {
        this.useDeflateEncoding = deflate;
    }

    protected String encodeToken(String assertion) throws Base64Exception {
        byte[] tokenBytes = assertion.getBytes(StandardCharsets.UTF_8);
        if (this.useDeflateEncoding) {
            tokenBytes = CompressionUtils.deflate((byte[])tokenBytes, (int)RESTSecurityTokenServiceImpl.getDeflateLevel(), (boolean)true);
        }
        StringWriter writer = new StringWriter();
        Base64Utility.encode((byte[])tokenBytes, (int)0, (int)tokenBytes.length, (Writer)writer);
        return writer.toString();
    }

    private static int getDeflateLevel() {
        Integer level = null;
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null) {
            level = PropertyUtils.getInteger((Message)m, (String)"deflate.level");
        }
        if (level == null) {
            level = 8;
        }
        return level;
    }

    static {
        DEFAULT_KEY_TYPE_MAP = new HashMap<String, String>();
        LOG = LogUtils.getL7dLogger(RESTSecurityTokenServiceImpl.class);
        HashMap<String, String> tmpClaimTypeMap = new HashMap<String, String>();
        tmpClaimTypeMap.put("emailaddress", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress");
        tmpClaimTypeMap.put("role", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role");
        tmpClaimTypeMap.put("roles", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role");
        tmpClaimTypeMap.put("surname", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
        tmpClaimTypeMap.put("givenname", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
        tmpClaimTypeMap.put("name", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
        tmpClaimTypeMap.put("upn", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn");
        tmpClaimTypeMap.put("nameidentifier", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier");
        DEFAULT_CLAIM_TYPE_MAP = Collections.unmodifiableMap(tmpClaimTypeMap);
        HashMap<String, String> tmpTokenTypeMap = new HashMap<String, String>();
        tmpTokenTypeMap.put("saml", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        tmpTokenTypeMap.put("saml2.0", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        tmpTokenTypeMap.put("saml1.1", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        tmpTokenTypeMap.put("jwt", "urn:ietf:params:oauth:token-type:jwt");
        tmpTokenTypeMap.put("sct", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
        DEFAULT_TOKEN_TYPE_MAP = Collections.unmodifiableMap(tmpTokenTypeMap);
        DEFAULT_KEY_TYPE_MAP.put("SymmetricKey", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
        DEFAULT_KEY_TYPE_MAP.put("PublicKey", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
        DEFAULT_KEY_TYPE_MAP.put("Bearer", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
    }

    private static class JSONWrapper {
        private String token;

        JSONWrapper(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }
}

