/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingCounter;
import org.apache.cxf.throttling.ThrottlingManager;

public class SimpleThrottlingManager
extends ThrottleResponse
implements ThrottlingManager {
    private static final String THROTTLED_KEY = "THROTTLED";
    private int threshold;
    private ThrottlingCounter counter = new ThrottlingCounter();

    @Override
    public List<String> getDecisionPhases() {
        return Collections.singletonList("pre-stream");
    }

    @Override
    public ThrottleResponse getThrottleResponse(String phase, Message m) {
        if (m.containsKey((Object)THROTTLED_KEY)) {
            return null;
        }
        m.getExchange().put(ThrottlingCounter.class, (Object)this.counter);
        if (this.counter.incrementAndGet() >= this.threshold) {
            m.put((Object)THROTTLED_KEY, (Object)true);
            return this;
        }
        return null;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

