/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.ForwardingRoute;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.util.Util;

public abstract class Relayer {
    protected final RELAY relay;
    protected final Log log;
    protected volatile boolean done;
    protected boolean stats;
    protected final Map<String, List<Route>> routes = new ConcurrentHashMap<String, List<Route>>(5);
    protected final Set<ForwardingRoute> forward_routes = new ConcurrentSkipListSet<ForwardingRoute>();

    public Relayer(RELAY relay, Log log) {
        this.relay = relay;
        this.log = log;
        this.stats = relay.statsEnabled();
    }

    public abstract void stop();

    public RELAY relay() {
        return this.relay;
    }

    public Log log() {
        return this.log;
    }

    public boolean done() {
        return this.done;
    }

    protected abstract View getBridgeView(String var1);

    protected Route getRoute(String site) {
        return this.getRoute(site, null);
    }

    public String toString() {
        return String.format("%d routes", this.routes.size());
    }

    protected synchronized Route getRoute(String site, Address sender) {
        List<Route> list = this.routes.get(site);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.relay.site_master_picker.pickRoute(site, list, sender);
    }

    protected synchronized List<Route> getRoutes(String ... excluded_sites) {
        ArrayList<Route> retval = new ArrayList<Route>(this.routes.size());
        block0: for (List<Route> list : this.routes.values()) {
            for (Route route : list) {
                if (route == null || Relayer.isExcluded(route, excluded_sites)) continue;
                retval.add(route);
                continue block0;
            }
        }
        return retval;
    }

    protected synchronized void addRoutes(String site, List<Route> new_routes) {
        this.routes.put(site, new_routes);
    }

    protected synchronized boolean hasRouteTo(String r) {
        return this.routes.containsKey(r);
    }

    protected synchronized void removeRoute(String site) {
        this.routes.remove(site);
    }

    protected synchronized List<Route> getRoutes(String site) {
        return this.routes.get(site);
    }

    protected synchronized String printRoutes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Route>> entry : this.routes.entrySet()) {
            List<Route> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            sb.append(entry.getKey() + " --> ").append(Util.print(list)).append("\n");
        }
        for (ForwardingRoute fr : this.forward_routes) {
            sb.append(String.format("%s --> %s [fwd]\n", fr.to(), fr.gateway()));
        }
        return sb.toString();
    }

    protected synchronized Route getForwardingRouteMatching(String site, Address sender) {
        if (site == null) {
            return null;
        }
        for (ForwardingRoute fr : this.forward_routes) {
            Route r;
            if (!fr.matches(site) || (r = this.getRoute(fr.gateway(), sender)) == null) continue;
            return r;
        }
        return null;
    }

    protected Collection<String> getSiteNames() {
        return Stream.concat(Stream.of(this.relay.site()), this.routes.keySet().stream()).collect(Collectors.toSet());
    }

    protected static boolean isExcluded(Route route, String ... excluded_sites) {
        if (excluded_sites == null) {
            return false;
        }
        String site = ((SiteUUID)route.site_master).getSite();
        for (String excluded_site : excluded_sites) {
            if (!site.equals(excluded_site)) continue;
            return true;
        }
        return false;
    }
}

