/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;

public class KeyAgreementProcessorRegistry {
    @Nonnull
    private Map<String, KeyAgreementProcessor> processors = new HashMap<String, KeyAgreementProcessor>();

    public void register(@Nonnull KeyAgreementProcessor processor) {
        Constraint.isNotNull((Object)processor, (String)"KeyAgreementProcessor was null");
        Constraint.isNotNull((Object)processor.getAlgorithm(), (String)"KeyAgreementProcessor algorithm was null");
        this.processors.put(processor.getAlgorithm(), processor);
    }

    public void deregister(@Nonnull String algorithm) {
        String alg = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)algorithm), (String)"KeyAgreementProcessor algorithm was null or empty");
        this.processors.remove(alg);
    }

    public void clear() {
        this.processors.clear();
    }

    @Nonnull
    public Set<String> getRegisteredAlgorithms() {
        return Set.copyOf(this.processors.keySet());
    }

    @Nullable
    public KeyAgreementProcessor getProcessor(@Nonnull String algorithm) {
        String alg = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)algorithm), (String)"KeyAgreementProcessor algorithm was null or empty");
        return this.processors.get(alg);
    }
}

