/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static List<Integer> asList(final int[] vals) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Short> asList(final short[] vals) {
        return new AbstractList<Short>(){

            @Override
            public Short get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Long> asList(final long[] vals) {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Character> asList(final char[] vals) {
        return new AbstractList<Character>(){

            @Override
            public Character get(int index) {
                return Character.valueOf(vals[index]);
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Byte> asList(final byte[] vals) {
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Float> asList(final float[] vals) {
        return new AbstractList<Float>(){

            @Override
            public Float get(int index) {
                return Float.valueOf(vals[index]);
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Double> asList(final double[] vals) {
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Object> asList(final Object[] vals) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static Collection<Object> newCollection(Object array) {
        ArrayList<Object> collection;
        if (array instanceof Object[]) {
            return ArrayUtil.asList((Object[])array);
        }
        if (array instanceof boolean[]) {
            collection = new ArrayList<Object>(((boolean[])array).length);
            for (boolean o : (boolean[])array) {
                collection.add(o);
            }
        } else if (array instanceof byte[]) {
            collection = new ArrayList(((byte[])array).length);
            for (byte o : (byte[])array) {
                collection.add(o);
            }
        } else if (array instanceof char[]) {
            collection = new ArrayList(((char[])array).length);
            for (char o : (char[])array) {
                collection.add(Character.valueOf(o));
            }
        } else if (array instanceof short[]) {
            collection = new ArrayList(((short[])array).length);
            for (short o : (short[])array) {
                collection.add(o);
            }
        } else if (array instanceof int[]) {
            collection = new ArrayList(((int[])array).length);
            for (int o : (int[])array) {
                collection.add(o);
            }
        } else if (array instanceof long[]) {
            collection = new ArrayList(((long[])array).length);
            for (long o : (long[])array) {
                collection.add(o);
            }
        } else if (array instanceof float[]) {
            collection = new ArrayList(((float[])array).length);
            for (float o : (float[])array) {
                collection.add(Float.valueOf(o));
            }
        } else if (array instanceof double[]) {
            collection = new ArrayList(((double[])array).length);
            for (double o : (double[])array) {
                collection.add(o);
            }
        } else {
            throw new IllegalArgumentException("This is not an array! " + array);
        }
        return collection;
    }
}

