/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectFloatsSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(Float.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank(0.5f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0, 1.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new float[]{0.0f});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF(new float[0]);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(1.0f);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(1.0f);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(1.0f);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1.0f, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0f, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((float)sketch.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sketch.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (float)1.0f);
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((float)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new float[]{500000.0f});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((float)sketch.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch.getMaxItem(), (float)999999.0f);
        double[] ranks = new double[1001];
        double[] reverseRanks = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            ranks[i2] = (double)i2 / 1000.0;
            reverseRanks[1000 - i2] = ranks[i2];
        }
        float[] quantiles = sketch.getQuantiles(ranks);
        float[] reverseQuantiles = sketch.getQuantiles(reverseRanks);
        float previousQuantile = 0.0f;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            float quantile = sketch.getQuantile(ranks[i3]);
            Assert.assertEquals((float)quantile, (float)quantiles[i3]);
            Assert.assertEquals((float)quantile, (float)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        int n = 1000;
        float[] values = new float[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i * 1.0f);
            sketch2.update((float)(20000 - i - 1) * 1.0f);
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
            sketch2.update((float)(20000 - i - 1));
        }
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)19999.0f);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.update(1.0f);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch1.update(1.0f);
        sketch2.update(2.0f);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)1.0f);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        int n = 1000000;
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)1000000.0f);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(7, 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(65536, 0);
    }

    @Test
    public void minK() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(8, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(65535, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmptyViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeEmptyViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllFloatsSketch sketch2 = KllFloatsSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test
    public void serializeDeserializeOneValueViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch1.update(1.0f);
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Float.isFinite(sketch2.getMinItem()));
        Assert.assertTrue((boolean)Float.isFinite(sketch2.getMaxItem()));
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)12);
    }

    @Test
    public void serializeDeserializeOneValueViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch1.update(1.0f);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllFloatsSketch sketch2 = KllFloatsSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)1.0f);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)12);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)bytes.length);
    }

    @Test
    public void serializeDeserializeFullViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 1000);
        byte[] byteArr1 = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((MemorySegment)MemorySegment.ofArray(byteArr1));
        Assert.assertEquals((int)byteArr1.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinItem(), (float)sketch1.getMinItem());
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeFullViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        int n = 1000;
        for (int i = 1; i <= 1000; ++i) {
            sketch1.update((float)i);
        }
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllFloatsSketch sketch2 = KllFloatsSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinItem(), (float)sketch1.getMinItem());
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(0.0f);
        sketch.getCDF(new float[]{1.0f, 0.0f});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 0);
        sketch.update(0.0f);
        sketch.getCDF(new float[]{Float.NaN});
    }

    @Test
    public void checkSimpleMergeDirect() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 43;
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (i = 1; i <= 21; ++i) {
            sk1.update((float)i);
        }
        for (i = 1; i <= 43; ++i) {
            sk2.update((float)(i + 100));
        }
        KllDirectFloatsSketchTest.println("SK1:");
        KllDirectFloatsSketchTest.println(sk1.toString(true, true));
        KllDirectFloatsSketchTest.println("SK2:");
        KllDirectFloatsSketchTest.println(sk2.toString(true, true));
        MemorySegment wseg1 = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)sk1, (boolean)true));
        MemorySegment wseg2 = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)sk2, (boolean)true));
        KllFloatsSketch dsk1 = KllFloatsSketch.wrap((MemorySegment)wseg1);
        KllFloatsSketch dsk2 = KllFloatsSketch.wrap((MemorySegment)wseg2);
        KllDirectFloatsSketchTest.println("BEFORE MERGE");
        KllDirectFloatsSketchTest.println(dsk1.toString(true, true));
        dsk1.merge((KllSketch)dsk2);
        KllDirectFloatsSketchTest.println("AFTER MERGE");
        KllDirectFloatsSketchTest.println(dsk1.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDirectFloatUpdatableMemorySegment() {
        int k = 20;
        KllDirectFloatsSketchTest.println("#### CASE: FLOAT FULL DIRECT FROM UPDATABLE");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_FLOATS_SKETCH, (boolean)true));
        KllFloatsSketch sk = KllFloatsSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectFloatsSketchTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)20);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_FLOATS_SKETCH, (boolean)true));
        sk = KllFloatsSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectFloatsSketchTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)20);
        sk2.update(1.0f);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_FLOATS_SKETCH, (boolean)true));
        sk = KllFloatsSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkGetMemorySegment() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getUpdatableDirectFloatSketch(200, 200);
        Assert.assertEquals((int)sketch.getK(), (int)200);
        Assert.assertEquals((long)sketch.getN(), (long)200L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isMemorySegmentUpdatableFormat());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertTrue((boolean)sketch.isKllFloatsSketch());
        Assert.assertFalse((boolean)sketch.isLevelZeroSorted());
        Assert.assertFalse((boolean)sketch.isKllDoublesSketch());
        MemorySegment wseg = sketch.getMemorySegment();
        KllHeapFloatsSketch sk = KllHeapFloatsSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)200);
        Assert.assertEquals((long)sk.getN(), (long)200L);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isMemorySegmentUpdatableFormat());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertTrue((boolean)sk.isKllFloatsSketch());
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        Assert.assertFalse((boolean)sk.isKllDoublesSketch());
    }

    @Test
    public void checkReset() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[3000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n1 = sk.getN();
        float min1 = sk.getMinItem();
        float max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n2 = sk.getN();
        float min2 = sk.getMinItem();
        float max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((float)min2, (float)min1);
        Assert.assertEquals((float)max2, (float)max1);
    }

    @Test
    public void checkHeapify() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        KllHeapFloatsSketch sk2 = KllHeapFloatsSketch.heapifyImpl((MemorySegment)dstSeg);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)100.0);
    }

    @Test
    public void checkMergeKllFloatsSketch() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((float)(i + 100));
        }
        sk.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)121.0);
    }

    @Test
    public void checkReverseMergeKllFloatsSketch() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((float)(i + 100));
        }
        sk2.merge((KllSketch)sk);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)121.0);
    }

    @Test
    public void checkWritableWrapOfCompactForm() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        MemorySegment srcSeg = MemorySegment.ofArray(sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((MemorySegment)srcSeg);
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)21.0f);
    }

    @Test
    public void checkReadOnlyExceptions() {
        int k = 20;
        float[] fltArr = new float[]{};
        float fltV = 1.0f;
        boolean idx = true;
        boolean bool = true;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        try {
            sk2.incN(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.incNumLevels();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setFloatItemsArray(fltArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setFloatItemsArrayAt(1, 1.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelZeroSorted(true);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMaxItem(1.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinItem(1.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinK(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setN(1L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setNumLevels(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMergeExceptions() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        MemorySegment srcSeg1 = MemorySegment.ofArray(sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((MemorySegment)srcSeg1);
        sk2.merge((KllSketch)sk1);
    }

    @Test
    public void checkVectorUpdate() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        float[] v = new float[21];
        for (int i = 0; i < 21; ++i) {
            v[i] = i + 1;
        }
        sk.update(v, 0, 21);
        KllDirectFloatsSketchTest.println(sk.toString(true, true));
        int[] levelsArr = sk.getLevelsArray(KllSketch.SketchStructure.UPDATABLE);
        Assert.assertEquals((int)levelsArr[0], (int)22);
        float[] floatsArr = sk.getFloatItemsArray();
        Assert.assertEquals((float)floatsArr[22], (float)21.0f);
    }

    @Test
    public void checkWeightedUpdate() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)8, (MemorySegment)dstSeg, null);
        for (int i = 0; i < 16; ++i) {
            sk.update((float)(i + 1), 16L);
        }
        KllDirectFloatsSketchTest.println(sk.toString(true, true));
        Assert.assertEquals((long)sk.getN(), (long)256L);
        Assert.assertEquals((float)sk.getMaxItem(), (float)16.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
    }

    private static KllFloatsSketch getUpdatableDirectFloatSketch(int k, int n) {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        return KllFloatsSketch.wrap((MemorySegment)wseg);
    }

    @Test
    public void checkMergeExceptionsWrongType() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk1.merge((KllSketch)sk2);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            sk2.merge((KllSketch)sk1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static final void println(Object o) {
    }
}

