/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleIntersectionTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void intersectionNotEmptyNoEntries() {
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.01f).build();
        sketch1.update("a", (Object)1.0);
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch1);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0, (double)1.0E-4);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionExactWithEmpty() {
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(3L, (Object)1.0);
        TupleSketch sketch2 = TupleSketch.createEmptySketch();
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch1);
        intersection.intersect(sketch2);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void intersectionExactMode() {
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        UpdatableTupleSketch sketch2 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch2.update(2L, (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch1);
        intersection.intersect((TupleSketch)sketch2);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)1.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)1.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)1.0);
        TupleSketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertTrue((it.getHash() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)4.0);
        Assert.assertFalse((boolean)it.next());
        intersection.reset();
        sketch1 = null;
        try {
            intersection.intersect((TupleSketch)sketch1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void intersectionDisjointEstimationMode() {
        int key = 0;
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        UpdatableTupleSketch sketch2 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch1);
        intersection.intersect((TupleSketch)sketch2);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        intersection.intersect((TupleSketch)sketch1);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionEstimationMode() {
        int key = 0;
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableTupleSketch sketch2 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch1);
        intersection.intersect((TupleSketch)sketch2);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        TupleSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
        }
    }

    @Test
    public void checkExactIntersectionWithTheta() {
        int i;
        ThetaSketch thSkNull = null;
        UpdatableThetaSketch thSkEmpty = new UpdatableThetaSketchBuilder().build();
        UpdatableThetaSketch thSk10 = new UpdatableThetaSketchBuilder().build();
        UpdatableThetaSketch thSk15 = new UpdatableThetaSketchBuilder().build();
        for (i = 0; i < 10; ++i) {
            thSk10.update((long)i);
        }
        for (i = 0; i < 10; ++i) {
            thSk15.update((long)(i + 5));
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        try {
            intersection.getResult();
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            intersection.intersect(thSkNull, (Summary)dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        intersection.intersect((ThetaSketch)thSkEmpty, (Summary)dsum);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        intersection.reset();
        intersection.intersect((ThetaSketch)thSk10, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)10.0);
        intersection.reset();
        intersection.intersect((ThetaSketch)thSk10, (Summary)dsum);
        intersection.intersect((ThetaSketch)thSkEmpty, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        intersection.reset();
        intersection.intersect((ThetaSketch)thSk10, (Summary)dsum);
        intersection.intersect((ThetaSketch)thSk15, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)5.0);
        intersection.reset();
        dsum = null;
        try {
            intersection.intersect((ThetaSketch)thSk10, (Summary)dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExactIntersectionWithThetaDisjoint() {
        int i;
        UpdatableThetaSketch thSkA = new UpdatableThetaSketchBuilder().setLogNominalEntries(10).build();
        UpdatableThetaSketch thSkB = new UpdatableThetaSketchBuilder().setLogNominalEntries(10).build();
        int key = 0;
        for (i = 0; i < 32; ++i) {
            thSkA.update((long)key++);
        }
        for (i = 0; i < 32; ++i) {
            thSkB.update((long)key++);
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((ThetaSketch)thSkA, (Summary)dsum);
        intersection.intersect((ThetaSketch)thSkB, (Summary)dsum);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.intersect((ThetaSketch)thSkA, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.reset();
    }

    @Test
    public void checkEstimatingIntersectionWithThetaOverlapping() {
        int i;
        UpdatableThetaSketch thSkA = new UpdatableThetaSketchBuilder().setLogNominalEntries(4).build();
        UpdatableThetaSketch thSkB = new UpdatableThetaSketchBuilder().setLogNominalEntries(10).build();
        for (i = 0; i < 64; ++i) {
            thSkA.update((long)i);
        }
        for (i = 32; i < 96; ++i) {
            thSkB.update((long)i);
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((ThetaSketch)thSkA, (Summary)dsum);
        intersection.intersect((ThetaSketch)thSkB, (Summary)dsum);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)14);
        thSkB.reset();
        for (int i2 = 100; i2 < 164; ++i2) {
            thSkB.update((long)i2);
        }
        intersection.intersect((ThetaSketch)thSkB, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.intersect((ThetaSketch)thSkB, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
    }

    @Test
    public void intersectionEmpty() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        TupleIntersection intersection = new TupleIntersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((TupleSketch)sketch);
        CompactTupleSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }
}

