/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.HeapNonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.HeapWritableBufferImpl;
import org.apache.datasketches.memory.internal.HeapWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.Util;

final class HeapNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private final Object unsafeObj;

    HeapNonNativeWritableBufferImpl(Object unsafeObj, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr) {
        super(capacityBytes);
        this.unsafeObj = unsafeObj;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = HeapNonNativeWritableBufferImpl.removeNnBuf(typeId) | 0 | 0x40 | 0x20;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = HeapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new HeapWritableBufferImpl(this.unsafeObj, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr);
        }
        return new HeapNonNativeWritableBufferImpl(this.unsafeObj, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = HeapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new HeapWritableMemoryImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new HeapNonNativeWritableMemoryImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = HeapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 4 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new HeapWritableBufferImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

