/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.HeapNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.HeapWritableBufferImpl;
import org.apache.datasketches.memory.internal.HeapWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Util;

final class HeapNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private final Object unsafeObj;

    HeapNonNativeWritableMemoryImpl(Object unsafeObj, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr) {
        this.unsafeObj = unsafeObj;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = HeapNonNativeWritableMemoryImpl.removeNnBuf(typeId) | 0 | 0 | 0x20;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = HeapNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new HeapWritableMemoryImpl(this.unsafeObj, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr);
        }
        return new HeapNonNativeWritableMemoryImpl(this.unsafeObj, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = HeapNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0x40 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new HeapWritableBufferImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

