/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.SketchToString;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToStringTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void normalCase() throws Exception {
        SketchToString func = new SketchToString();
        KllFloatsSketch sketch = new KllFloatsSketch();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void noInputs() throws Exception {
        SketchToString func = new SketchToString();
        func.exec(TUPLE_FACTORY.newTuple());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        SketchToString func = new SketchToString();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        SketchToString func = new SketchToString();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }
}

