/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.io.IOException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class DataToSketch
extends EvalFunc<DataByteArray>
implements Accumulator<DataByteArray>,
Algebraic {
    private static final TupleFactory TUPLE_FACTORY_ = TupleFactory.getInstance();
    private final int k_;
    private KllFloatsSketch accumSketch_;

    public DataToSketch() {
        this(200);
    }

    public DataToSketch(String kStr) {
        this(Integer.parseInt(kStr));
    }

    private DataToSketch(int k) {
        this.k_ = k;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        KllFloatsSketch sketch = new KllFloatsSketch(this.k_);
        if (inputTuple != null && inputTuple.size() > 0) {
            DataBag bag = (DataBag)inputTuple.get(0);
            for (Tuple innerTuple : bag) {
                sketch.update(((Float)innerTuple.get(0)).floatValue());
            }
        }
        return new DataByteArray(sketch.toByteArray());
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new KllFloatsSketch(this.k_);
        }
        for (Tuple innerTuple : bag) {
            this.accumSketch_.update(((Float)innerTuple.get(0)).floatValue());
        }
    }

    public DataByteArray getValue() {
        if (this.accumSketch_ != null) {
            return new DataByteArray(this.accumSketch_.toByteArray());
        }
        return new DataByteArray(new KllFloatsSketch(this.k_).toByteArray());
    }

    public void cleanup() {
        this.accumSketch_ = null;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    private static DataByteArray process(Tuple inputTuple, int k) throws IOException {
        KllFloatsSketch sketch = new KllFloatsSketch(k);
        if (inputTuple != null && inputTuple.size() > 0) {
            DataBag outerBag = (DataBag)inputTuple.get(0);
            for (Tuple dataTuple : outerBag) {
                Object f0 = dataTuple.get(0);
                if (f0 == null) continue;
                if (f0 instanceof DataBag) {
                    DataBag innerBag = (DataBag)f0;
                    if (innerBag.size() == 0L) continue;
                    for (Tuple innerTuple : innerBag) {
                        sketch.update(((Float)innerTuple.get(0)).floatValue());
                    }
                    continue;
                }
                if (f0 instanceof DataByteArray) {
                    DataByteArray dba = (DataByteArray)f0;
                    sketch.merge(KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])dba.get())));
                    continue;
                }
                throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
            }
        }
        return new DataByteArray(sketch.toByteArray());
    }

    public static class Final
    extends EvalFunc<DataByteArray> {
        private final int k_;

        public Final() {
            this(200);
        }

        public Final(String kStr) {
            this(Integer.parseInt(kStr));
        }

        private Final(int k) {
            this.k_ = k;
        }

        public DataByteArray exec(Tuple inputTuple) throws IOException {
            return DataToSketch.process(inputTuple, this.k_);
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private final int k_;

        public Intermediate() {
            this(200);
        }

        public Intermediate(String kStr) {
            this(Integer.parseInt(kStr));
        }

        private Intermediate(int k) {
            this.k_ = k;
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return TUPLE_FACTORY_.newTuple((Object)DataToSketch.process(inputTuple, this.k_));
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
        }

        public Initial(String kStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

