/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptCommonImpl;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.Algebraic;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class DataToVarOptSketch
extends AccumulatorEvalFunc<DataByteArray>
implements Algebraic {
    private static final ArrayOfTuplesSerDe serDe_ = new ArrayOfTuplesSerDe();
    private final int targetK_;
    private final int weightIdx_;
    private VarOptItemsSketch<Tuple> sketch_;

    public DataToVarOptSketch(String kStr) {
        this.targetK_ = Integer.parseInt(kStr);
        this.weightIdx_ = 0;
        if (this.targetK_ < 1) {
            throw new IllegalArgumentException("DataToVarOptSketch requires target sample size >= 1: " + this.targetK_);
        }
    }

    public DataToVarOptSketch(String kStr, String weightIdxStr) {
        this.targetK_ = Integer.parseInt(kStr);
        this.weightIdx_ = Integer.parseInt(weightIdxStr);
        if (this.targetK_ < 1) {
            throw new IllegalArgumentException("DataToVarOptSketch requires target sample size >= 1: " + this.targetK_);
        }
        if (this.weightIdx_ < 0) {
            throw new IllegalArgumentException("DataToVarOptSketch requires weight index >= 0: " + this.weightIdx_);
        }
    }

    DataToVarOptSketch() {
        this.targetK_ = 1024;
        this.weightIdx_ = 0;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
            return;
        }
        DataBag samples = (DataBag)inputTuple.get(0);
        if (this.sketch_ == null) {
            this.sketch_ = VarOptItemsSketch.newInstance((int)this.targetK_);
        }
        for (Tuple t : samples) {
            double weight = (Double)t.get(this.weightIdx_);
            this.sketch_.update((Object)t, weight);
        }
    }

    public DataByteArray getValue() {
        if (this.sketch_ == null) {
            return null;
        }
        return new DataByteArray(this.sketch_.toByteArray((ArrayOfItemsSerDe)serDe_));
    }

    public void cleanup() {
        this.sketch_ = null;
    }

    public String getInitial() {
        return VarOptCommonImpl.RawTuplesToSketchTuple.class.getName();
    }

    public String getIntermed() {
        return VarOptCommonImpl.UnionSketchesAsTuple.class.getName();
    }

    public String getFinal() {
        return VarOptCommonImpl.UnionSketchesAsByteArray.class.getName();
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input == null || input.size() == 0) {
                throw new IllegalArgumentException("Degenerate input schema to VarOptSampling");
            }
            if (input.getField((int)0).type != 120) {
                throw new IllegalArgumentException("VarOpt input must be a data bag: " + input.toString());
            }
            Schema record = input.getField((int)0).schema;
            Schema fields = record.getField((int)0).schema;
            if (fields.getField((int)this.weightIdx_).type != 25 && fields.getField((int)this.weightIdx_).type != 20) {
                throw new IllegalArgumentException("weightIndex item of VarOpt tuple must be a weight (double/float), found " + fields.getField((int)0).type + ": " + fields.toString());
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 50));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

