/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.shared.common.sanity.SanityManager;

public class FormatableArrayHolder
implements Formatable {
    private Object[] array;

    public FormatableArrayHolder() {
    }

    public FormatableArrayHolder(Object[] array) {
        SanityManager.ASSERT(array != null, "array input to constructor is null, code can't handle this.");
        this.setArray(array);
    }

    public void setArray(Object[] array) {
        SanityManager.ASSERT(array != null, "array input to setArray() is null, code can't handle this.");
        this.array = ArrayUtil.copy(array);
    }

    public <E> E[] getArray(Class<E[]> arrayClass) {
        return Arrays.copyOf(this.array, this.array.length, arrayClass);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(this.array != null, "Array is null, which isn't expected");
        ArrayUtil.writeArrayLength(out, this.array);
        ArrayUtil.writeArrayItems(out, this.array);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.array = new Object[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.array);
    }

    @Override
    public int getTypeFormatId() {
        return 270;
    }
}

