/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.BulkInsertCounter;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;
import org.apache.derby.impl.sql.catalog.SequenceRange;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class SequenceUpdater
implements Cacheable {
    protected DataDictionaryImpl _dd;
    protected String _uuidString;
    protected SequenceGenerator _sequenceGenerator;

    public SequenceUpdater() {
    }

    public SequenceUpdater(DataDictionaryImpl dd) {
        this();
        this._dd = dd;
    }

    protected abstract SequenceGenerator createSequenceGenerator(TransactionController var1) throws StandardException;

    protected abstract boolean updateCurrentValueOnDisk(TransactionController var1, Long var2, Long var3, boolean var4) throws StandardException;

    private StandardException tooMuchContentionException() {
        if ("SYS".equals(this._sequenceGenerator.getSchemaName())) {
            return StandardException.newException("40XL1", new Object[0]);
        }
        return StandardException.newException("X0Y84.T", this._sequenceGenerator.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(boolean forRemove) throws StandardException {
        block6: {
            boolean gapClosed = false;
            try {
                gapClosed = this._sequenceGenerator == null ? true : this.updateCurrentValueOnDisk(null, this.peekAtCurrentValue());
                if (gapClosed) break block6;
            }
            catch (StandardException se) {
                block7: {
                    try {
                        if (!"X0Y84.T".equals(se.getMessageId())) {
                            throw se;
                        }
                        if (gapClosed) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!gapClosed) {
                            String errorMessage = MessageService.getTextMessage("X0Y86.S", this._sequenceGenerator.getSchemaName(), this._sequenceGenerator.getName());
                            Monitor.getStream().println(errorMessage);
                        }
                        this._uuidString = null;
                        this._sequenceGenerator = null;
                        throw throwable;
                    }
                    String errorMessage = MessageService.getTextMessage("X0Y86.S", this._sequenceGenerator.getSchemaName(), this._sequenceGenerator.getName());
                    Monitor.getStream().println(errorMessage);
                }
                this._uuidString = null;
                this._sequenceGenerator = null;
            }
            String errorMessage = MessageService.getTextMessage("X0Y86.S", this._sequenceGenerator.getSchemaName(), this._sequenceGenerator.getName());
            Monitor.getStream().println(errorMessage);
        }
        this._uuidString = null;
        this._sequenceGenerator = null;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public Object getIdentity() {
        return this._uuidString;
    }

    @Override
    public void clearIdentity() {
        block2: {
            try {
                this.clean(false);
            }
            catch (StandardException se) {
                LanguageConnectionContext lcc = SequenceUpdater.getLCC();
                if (lcc == null) break block2;
                Database db = lcc.getDatabase();
                boolean isactive = db != null ? db.isActive() : false;
                lcc.getContextManager().cleanupOnError(se, isactive);
            }
        }
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        SequenceUpdater cacheable = this;
        return cacheable.setIdentity(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (!(key instanceof String)) {
            SanityManager.THROWASSERT("Key for a SequenceUpdater is a " + key.getClass().getName());
        }
        if (this._uuidString != null || this._sequenceGenerator != null) {
            SanityManager.THROWASSERT("Identity being changed on a live cacheable. Old uuidString = " + this._uuidString);
        }
        this._uuidString = (String)key;
        if (this._sequenceGenerator == null) {
            TransactionController executionTC = SequenceUpdater.getLCC().getTransactionExecute();
            TransactionController subTransaction = executionTC.startNestedUserTransaction(true, true);
            try {
                this._sequenceGenerator = this.createSequenceGenerator(subTransaction);
            }
            finally {
                if (this._sequenceGenerator == null) {
                    this._uuidString = null;
                }
                subTransaction.commit();
                subTransaction.destroy();
            }
        }
        if (this._sequenceGenerator != null) {
            return this;
        }
        return null;
    }

    public synchronized void reset(Long newValue) throws StandardException {
        this.updateCurrentValueOnDisk(null, newValue);
        this._sequenceGenerator = this._sequenceGenerator.clone(newValue);
    }

    public synchronized BulkInsertUpdater getBulkInsertUpdater(boolean restart) throws StandardException {
        return new BulkInsertUpdater(this, restart);
    }

    public synchronized void getCurrentValueAndAdvance(NumberDataValue returnValue) throws StandardException {
        block5: for (int i = 0; i < 2; ++i) {
            long[] cvaa = this._sequenceGenerator.getCurrentValueAndAdvance();
            int status = (int)cvaa[0];
            long currentValue = cvaa[1];
            long lastAllocatedValue = cvaa[2];
            long numberOfValuesAllocated = cvaa[3];
            switch (status) {
                case 1: {
                    returnValue.setValue(currentValue);
                    return;
                }
                case 2: {
                    this.updateCurrentValueOnDisk(currentValue, null);
                    returnValue.setValue(currentValue);
                    return;
                }
                case 3: {
                    if (!this.updateCurrentValueOnDisk(currentValue, lastAllocatedValue)) continue block5;
                    this._sequenceGenerator.allocateNewRange(currentValue, numberOfValuesAllocated);
                    continue block5;
                }
                default: {
                    throw this.unimplementedFeature();
                }
            }
        }
        throw this.tooMuchContentionException();
    }

    public Long peekAtCurrentValue() throws StandardException {
        return this._sequenceGenerator.peekAtCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCurrentValueOnDisk(Long oldValue, Long newValue) throws StandardException {
        LanguageConnectionContext lcc = SequenceUpdater.getLCC();
        if (lcc == null) {
            SanityManager.ASSERT(oldValue == null, "We should be flushing unused sequence values here.");
            ContextService csf = SequenceUpdater.getContextService();
            ContextManager cm = csf.getCurrentContextManager();
            AccessFactory af = this._dd.af;
            TransactionController dummyTransaction = af.getTransaction(cm);
            boolean retval = this.updateCurrentValueOnDisk(dummyTransaction, oldValue, newValue, false);
            dummyTransaction.commit();
            dummyTransaction.destroy();
            return retval;
        }
        TransactionController executionTransaction = lcc.getTransactionExecute();
        TransactionController nestedTransaction = executionTransaction.startNestedUserTransaction(false, true);
        if (nestedTransaction != null) {
            boolean retval = false;
            boolean escalateToParentTransaction = false;
            try {
                retval = this.updateCurrentValueOnDisk(nestedTransaction, oldValue, newValue, false);
                return retval;
            }
            catch (StandardException se) {
                if (!se.isLockTimeout()) {
                    if (se.isSelfDeadlock()) {
                        escalateToParentTransaction = true;
                    }
                    Monitor.logThrowable(se);
                    throw se;
                }
            }
            finally {
                nestedTransaction.commit();
                nestedTransaction.destroy();
                if (escalateToParentTransaction) {
                    retval = this.updateCurrentValueOnDisk(executionTransaction, oldValue, newValue, false);
                }
                return retval;
            }
        }
        throw this.tooMuchContentionException();
    }

    protected SequencePreallocator makePreallocator(TransactionController tc) throws StandardException {
        String propertyName = "derby.language.sequence.preallocator";
        String className = PropertyUtil.getServiceProperty(tc, propertyName);
        if (className == null) {
            return new SequenceRange();
        }
        try {
            if (this.isNumber(className)) {
                return new SequenceRange(Integer.parseInt(className));
            }
            Class<?> klass = Class.forName(className);
            if (!SequencePreallocator.class.isAssignableFrom(klass)) {
                throw StandardException.newException("X0Y85.S.1", propertyName);
            }
            return (SequencePreallocator)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (ClassCastException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (InstantiationException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (IllegalAccessException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (NumberFormatException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (NoSuchMethodException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
        catch (InvocationTargetException e) {
            throw this.missingAllocator(propertyName, className, e);
        }
    }

    private StandardException missingAllocator(String propertyName, String className, Exception e) {
        return StandardException.newException("X0Y85.S", e, propertyName, className);
    }

    private boolean isNumber(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)SequenceUpdater.getContextOrNull("LanguageConnectionContext");
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S", new Object[0]);
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }

    public static final class BulkInsertUpdater
    extends SequenceUpdater
    implements BulkInsertCounter {
        public BulkInsertUpdater() {
        }

        public BulkInsertUpdater(SequenceUpdater originalUpdater, boolean restart) {
            this._sequenceGenerator = originalUpdater._sequenceGenerator.clone(restart);
        }

        @Override
        protected SequenceGenerator createSequenceGenerator(TransactionController readOnlyTC) throws StandardException {
            return this._sequenceGenerator;
        }

        @Override
        protected boolean updateCurrentValueOnDisk(TransactionController tc, Long oldValue, Long newValue, boolean wait) throws StandardException {
            return true;
        }
    }

    public static final class SyssequenceUpdater
    extends SequenceUpdater {
        private RowLocation _sequenceRowLocation;

        public SyssequenceUpdater() {
        }

        public SyssequenceUpdater(DataDictionaryImpl dd) {
            super(dd);
        }

        @Override
        protected SequenceGenerator createSequenceGenerator(TransactionController readOnlyTC) throws StandardException {
            RowLocation[] rowLocation = new RowLocation[1];
            SequenceDescriptor[] sequenceDescriptor = new SequenceDescriptor[1];
            this._dd.computeSequenceRowLocation(readOnlyTC, this._uuidString, rowLocation, sequenceDescriptor);
            this._sequenceRowLocation = rowLocation[0];
            SequenceDescriptor isd = sequenceDescriptor[0];
            return new SequenceGenerator(isd.getCurrentValue(), isd.canCycle(), isd.getIncrement(), isd.getMaximumValue(), isd.getMinimumValue(), isd.getStartValue(), isd.getSchemaDescriptor().getSchemaName(), isd.getSequenceName(), this.makePreallocator(readOnlyTC));
        }

        @Override
        protected boolean updateCurrentValueOnDisk(TransactionController tc, Long oldValue, Long newValue, boolean wait) throws StandardException {
            return this._dd.updateCurrentSequenceValue(tc, this._sequenceRowLocation, wait, oldValue, newValue);
        }
    }
}

