/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class VarbitConstantNode
extends BitConstantNode {
    static final int K_VAR = 0;
    static final int K_LONGVAR = 1;
    static final int K_BLOB = 2;
    final int kind;

    VarbitConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(t, cm);
        switch (t.getJDBCTypeId()) {
            case -3: {
                this.kind = 0;
                break;
            }
            case -4: {
                this.kind = 1;
                break;
            }
            case 2004: {
                this.kind = 2;
                break;
            }
            default: {
                SanityManager.NOTREACHED();
                this.kind = -1;
            }
        }
    }

    VarbitConstantNode(String hexValue, int bitLength, ContextManager cm) throws StandardException {
        super(hexValue, bitLength, cm);
        this.kind = 0;
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((VarbitConstantNode)o).kind == this.kind;
    }
}

