/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClassLoaderTestSetup
extends BaseJDBCTestSetup {
    private ClassLoader oldLoader;

    public ClassLoaderTestSetup(Test test) {
        super(test);
    }

    private static ClassLoader makeClassLoader() {
        PrivilegedAction<ClassLoader> pa = () -> new URLClassLoader(new URL[0]);
        return AccessController.doPrivileged(pa);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestConfiguration.getCurrent().shutdownEngine();
        this.oldLoader = ClassLoaderTestSetup.getThreadLoader();
        ClassLoaderTestSetup.setThreadLoader(ClassLoaderTestSetup.makeClassLoader());
    }

    @Override
    protected void tearDown() throws Exception {
        ClassLoaderTestSetup.setThreadLoader(this.oldLoader);
        super.tearDown();
    }

    public static void setThreadLoader(final ClassLoader which) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(which);
                return null;
            }
        });
    }

    public static ClassLoader getThreadLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

