/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.suites;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.AccessTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public final class EncryptionSuite
extends BaseJDBCTestCase {
    public EncryptionSuite(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Encrpytion Suite");
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest(Decorator.encryptedDatabase(EncryptionSuite.baseSuite("default")));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("AES/CBC/NoPadding"));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("DES/ECB/NoPadding"));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("DESede/CFB/NoPadding"));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("DES/CBC/NoPadding"));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("Blowfish/CBC/NoPadding"));
            baseTestSuite.addTest(EncryptionSuite.encryptedSuite("AES/OFB/NoPadding"));
        }
        return baseTestSuite;
    }

    private static Test encryptedSuite(String string) {
        return Decorator.encryptedDatabase(EncryptionSuite.baseSuite(string), string);
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Encryption Algorithm: " + string);
        baseTestSuite.addTestSuite(EncryptionSuite.class);
        Properties properties = new Properties();
        properties.put("derby.optimizer.optimizeJoinOrder", "false");
        properties.put("derby.optimizer.ruleBasedOptimization", "true");
        properties.put("derby.optimizer.noTimeout", "true");
        baseTestSuite.addTestSuite(AccessTest.class);
        return baseTestSuite;
    }

    protected void setUp() {
        try {
            Connection connection = this.getConnection();
            Statement statement = this.createStatement();
            statement.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void tearDown() throws Exception {
        Statement statement = this.createStatement();
        super.tearDown();
        try {
            statement.executeUpdate("DROP FUNCTION PADSTRING");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testEncryptedDBConnection() throws SQLException {
        this.getConnection().close();
    }
}

