/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derbyTesting.functionTests.tests.lang.ConstraintCharacteristicsTest;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewOptimizerOverridesTest
extends GeneratedColumnsHelper {
    private static final String WRONG_ROW_SOURCE_COUNT = "42ZCC";
    private static final String NOT_LEFT_DEEP = "42ZCD";
    private static final String MISSING_INDEX = "42X65";
    private static final String MISSING_FUNCTION = "42X94";
    private static final String MISSING_SCHEMA = "42Y07";
    private static final String UNSUPPORTED_PLAN_SHAPE = "42Y69";

    public NewOptimizerOverridesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NewOptimizerOverridesTest");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(NewOptimizerOverridesTest.class));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection connection = this.getConnection();
        if (!this.routineExists(connection, "INTEGERLIST")) {
            this.goodStatement(connection, "create function integerList()\nreturns table( a int, b int, c int, d int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        }
        if (!this.tableExists(connection, "V")) {
            this.goodStatement(connection, "create view v as select tablename from sys.systables");
        }
    }

    public void test_01_basicSyntax() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n");
        this.goodStatement(connection, "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n");
        this.goodStatement(connection, "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n");
        this.goodStatement(connection, "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n--derbyplan ( app.integerList() # sys.syscolumns_heap )\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan sys.syscolumns_heap\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan sys.syscolumns_heap\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( ( sys.syscolumns_heap # sys.syscolumns_heap ) * sys.syscolumns_heap )\n");
        this.expectCompilationError(MISSING_INDEX, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A * C )\n");
        this.expectCompilationError(MISSING_FUNCTION, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A() * C )\n");
        this.expectCompilationError(MISSING_SCHEMA, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A.B * C )\n");
        this.expectCompilationError(MISSING_SCHEMA, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A.B # C.D )\n");
        this.expectCompilationError(NOT_LEFT_DEEP, "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan ( A.B # ( C.D * E ) )\n");
        this.expectCompilationError("42X01", "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan blah blah blah ( ( A.B # C.D ) * E )\n");
        this.expectCompilationError("42X02", "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan ( ( A.B # C.D ) $ E )\n");
    }

    public void test_02_simpleSelects() throws Exception {
        Connection connection = this.getConnection();
        String string = "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n";
        NewOptimizerOverridesTest.assertPlanShape(connection, string, "( org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest # SYSCOLUMNS )");
        NewOptimizerOverridesTest.assertPlanShape(connection, string + "\n--derbyplan ( sys.syscolumns_heap * app.integerList() )\n", "( SYSCOLUMNS * org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, string + "\n--derbyplan ( sys.syscolumns_heap # app.integerList() )");
        string = "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a, sys.syssequences s\nwhere t.tablename = c.columnname and c.columnname = a.alias and a.alias = s.sequencename\n";
        NewOptimizerOverridesTest.assertPlanShape(connection, string + "--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSALIASES_INDEX1) # SYS.SYSTABLES_INDEX1 )\n", "( ( ( SYSSEQUENCES_INDEX2 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) # SYSTABLES_INDEX1 )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, string + "\n--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSCOLUMNS_HEAP) # SYS.SYSTABLES_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and tablename = alias\n--derbyplan ( ( sys.systables_index1 # sys.syscolumns_heap ) # sys.sysaliases_index1 )\nunion all\nselect columnname from sys.systables t, sys.syscolumns c, sys.syssequences s\nwhere tablename = columnname and tablename = sequencename\n--derbyplan ( ( sys.systables_index1 # sys.syssequences_index2 ) # sys.syscolumns_heap )\n", "( ( ( SYSTABLES_INDEX1 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) ) union ( ( ( SYSTABLES_INDEX1 # SYSSEQUENCES_INDEX2 ) # SYSCOLUMNS ) )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid, c.referenceid\nfrom sys.systables, ( select referenceid from sys.syscolumns ) c\nwhere 1=2\n--derbyplan ( sys.systables_heap * sys.syscolumns_heap )\n", "( SYSTABLES * SYSCOLUMNS )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid\nfrom sys.systables\nwhere tableid not in ( select referenceid from sys.syscolumns )\n--derbyplan ( sys.systables_heap # sys.syscolumns_index1 )\n", "( SYSTABLES # SYSCOLUMNS_INDEX1 )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, "select tableid\nfrom sys.systables\nwhere exists ( select referenceid from sys.syscolumns where 1= 2 )\n--derbyplan ( sys.syscolumns_index1 * sys.systables_heap )\n");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid\nfrom sys.systables\nwhere exists ( select referenceid from sys.syscolumns where 1= 2 )\n--derbyplan ( sys.systables_heap * sys.syscolumns_index1 )\n", "( SYSTABLES * SYSCOLUMNS_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid\nfrom sys.systables\nwhere tableid in ( select referenceid || 'foo' from sys.syscolumns )\n--derbyplan ( sys.systables_heap * sys.syscolumns_index1 )\n", "( SYSTABLES * SYSCOLUMNS_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid\nfrom sys.systables t\nwhere tableid =\n(\n    select referenceid from sys.syscolumns where referenceid = t.tableid and 1=2\n    --derbyplan sys.syscolumns_index1\n)\n--derbyplan sys.systables_heap\n", "SYSCOLUMNS_INDEX1\nSYSTABLES");
    }

    public void test_03_offsetFetch() throws Exception {
        Connection connection = this.getConnection();
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a, sys.syssequences s\nwhere t.tablename = c.columnname and c.columnname = a.alias and a.alias = s.sequencename\n--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSALIASES_INDEX1) # SYS.SYSTABLES_INDEX1 )\nfetch first 1 rows only", "( ( ( SYSSEQUENCES_INDEX2 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) # SYSTABLES_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(connection, "select tableid\nfrom sys.systables t\nwhere tableid =\n(\n    select referenceid from sys.syscolumns where referenceid = t.tableid and 1=2\n    --derbyplan sys.syscolumns_index1\n    fetch first 1 rows only\n)\n--derbyplan sys.systables_heap\n", "SYSCOLUMNS_INDEX1\nSYSTABLES");
    }

    private boolean routineExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.sysaliases where alias = ?");
        preparedStatement.setString(1, string);
        java.sql.ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private boolean tableExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.systables where tablename = ?");
        preparedStatement.setString(1, string);
        java.sql.ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    static void assertPlanShape(Connection connection, String string, String string2) throws Exception {
        java.sql.ResultSet resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
        }
        resultSet.close();
        String string3 = NewOptimizerOverridesTest.summarize(NewOptimizerOverridesTest.getLastQueryPlan(connection, resultSet));
        NewOptimizerOverridesTest.println("Expected plan shape = " + string2);
        NewOptimizerOverridesTest.println("Actual plan shape = " + string3);
        NewOptimizerOverridesTest.assertEquals((String)string2, (String)string3);
    }

    public static Document getLastQueryPlan(Connection connection, java.sql.ResultSet resultSet) throws Exception {
        LanguageConnectionContext languageConnectionContext = ConstraintCharacteristicsTest.getLCC(connection);
        ResultSet resultSet2 = languageConnectionContext.getLastActivation().getResultSet();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("planTrace");
        document.appendChild(element);
        resultSet2.toXML(element, "top");
        return document;
    }

    public static String summarize(Document document) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Element element = NewOptimizerOverridesTest.getFirstElement(document.getDocumentElement(), "top");
        NewOptimizerOverridesTest.summarize(stringBuilder, element);
        return stringBuilder.toString();
    }

    private static void summarize(StringBuilder stringBuilder, Element element) throws Exception {
        String string = element.getAttribute("type");
        if ("HashJoinResultSet".equals(string)) {
            NewOptimizerOverridesTest.summarizeJoin(stringBuilder, element, "#");
        } else if ("NestedLoopJoinResultSet".equals(string)) {
            NewOptimizerOverridesTest.summarizeJoin(stringBuilder, element, "*");
        } else if ("ProjectRestrictResultSet".equals(string)) {
            NewOptimizerOverridesTest.summarizeProjectRestrict(stringBuilder, element);
        } else if ("RowCountResultSet".equals(string)) {
            NewOptimizerOverridesTest.summarizeProjectRestrict(stringBuilder, NewOptimizerOverridesTest.getFirstElement(element, "source"));
        } else if ("UnionResultSet".equals(string)) {
            NewOptimizerOverridesTest.summarizeUnion(stringBuilder, element);
        } else {
            String string2 = element.getAttribute("indexName");
            String string3 = element.getAttribute("tableName");
            String string4 = element.getAttribute("javaClassName");
            if (string2.length() != 0) {
                stringBuilder.append(string2);
            } else if (string3.length() != 0) {
                stringBuilder.append(string3);
            } else if (string4.length() != 0) {
                stringBuilder.append(string4);
            } else {
                stringBuilder.append(string);
            }
        }
    }

    private static void summarizeProjectRestrict(StringBuilder stringBuilder, Element element) throws Exception {
        Element element2 = NewOptimizerOverridesTest.getFirstElement(element, "array");
        if (element2 != null) {
            NewOptimizerOverridesTest.summarizeSubqueries(stringBuilder, element2);
        }
        NewOptimizerOverridesTest.summarize(stringBuilder, NewOptimizerOverridesTest.getFirstElement(element, "source"));
    }

    private static void summarizeSubqueries(StringBuilder stringBuilder, Element element) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"cell".equals(node.getNodeName())) continue;
            Element element2 = NewOptimizerOverridesTest.getFirstElement((Element)node, "source");
            NewOptimizerOverridesTest.summarize(stringBuilder, element2);
            stringBuilder.append("\n");
        }
    }

    private static void summarizeJoin(StringBuilder stringBuilder, Element element, String string) throws Exception {
        stringBuilder.append("( ");
        NewOptimizerOverridesTest.summarize(stringBuilder, NewOptimizerOverridesTest.getFirstElement(element, "leftResultSet"));
        stringBuilder.append(" " + string + " ");
        NewOptimizerOverridesTest.summarize(stringBuilder, NewOptimizerOverridesTest.getFirstElement(element, "rightResultSet"));
        stringBuilder.append(" )");
    }

    private static void summarizeUnion(StringBuilder stringBuilder, Element element) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (i > 0) {
                stringBuilder.append(" union ");
            }
            stringBuilder.append("( ");
            NewOptimizerOverridesTest.summarize(stringBuilder, element2);
            stringBuilder.append(" )");
        }
    }

    private static Element getFirstElement(Element element, String string) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    static String printDocument(Document document) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }
}

