/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesConferredPrivilegesTest
extends BaseJDBCTestCase {
    private static final String pwSuffix = "pwSuffix";
    private static final String NOEXECUTEPERMISSION = "42504";
    private static final String NOTABLEPERMISSION = "42500";
    private static final String NOCOLUMNPERMISSION = "42502";
    private static final String TABLENOTFOUND = "42X05";
    private static final String OBJECTNOTFOUND = "42X94";
    private static final String FKVIOLATION = "23503";
    private static final String CHECKCONSTRAINTVIOLATED = "23513";
    private static final String ALREADYCLOSED = "XJ012";
    private static final String CONSTRAINTDROPPED = "01500";
    private static final String VIEWDROPPED = "01501";
    private static final String TRIGGERDROPPED = "01502";
    private static final String UNRELIABLE = "42Y39";
    private static final String[] users = new String[]{"test_dbo", "DonaldDuck", "MickeyMouse"};
    private static final int GRANT = 0;
    private static final int REVOKE = 1;
    private static final int NOPRIV = 0;
    private static final int VIAUSER = 1;
    private static final int VIAROLE = 2;
    private static final String g_r = "references on s1.t1 ";
    private static final String g_r_c1 = "references (c1) on s1.t1 ";
    private static final String g_r_c2 = "references (c2) on s1.t1 ";
    private static final String g_r_c3 = "references (c3) on s1.t1 ";
    private static final String g_u = "update on s1.t1 ";
    private static final String g_u_c1 = "update (c1) on s1.t1 ";
    private static final String g_u_c2 = "update (c2) on s1.t1 ";
    private static final String g_u_c3 = "update (c3) on s1.t1 ";
    private static final String g_u_c1_c2_c3 = "update (c1,c2,c3) on s1.t1 ";
    private static final String g_i = "insert on s1.t1 ";
    private static final String g_s = "select on s1.t1 ";
    private static final String g_s_c1 = "select (c1) on s1.t1 ";
    private static final String g_s_c2 = "select (c2) on s1.t1 ";
    private static final String g_s_c3 = "select (c3) on s1.t1 ";
    private static final String g_d = "delete on s1.t1 ";
    private static final String g_t = "trigger on s1.t1 ";
    private static final String g_e = "execute on function s1.f1 ";
    private static final String g_e_f2 = "execute on function s1.f2 ";
    private static final String[] g_all = new String[]{"references on s1.t1 ", "references (c1) on s1.t1 ", "references (c2) on s1.t1 ", "references (c3) on s1.t1 ", "update on s1.t1 ", "update (c1) on s1.t1 ", "update (c2) on s1.t1 ", "update (c3) on s1.t1 ", "insert on s1.t1 ", "select on s1.t1 ", "select (c1) on s1.t1 ", "select (c2) on s1.t1 ", "select (c3) on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[] g_all_col = new String[]{"references (c1) on s1.t1 ", "references (c2) on s1.t1 ", "references (c3) on s1.t1 ", "update (c1) on s1.t1 ", "update (c2) on s1.t1 ", "update (c3) on s1.t1 ", "insert on s1.t1 ", "select (c1) on s1.t1 ", "select (c2) on s1.t1 ", "select (c3) on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[] g_all_tab = new String[]{"references on s1.t1 ", "update on s1.t1 ", "insert on s1.t1 ", "select on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[][] grantRevokes = new String[][]{g_all, g_all_col, g_all_tab};

    public RolesConferredPrivilegesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RolesConferredPrivilegesTest");
        baseTestSuite.addTest(RolesConferredPrivilegesTest.makeSuite());
        return baseTestSuite;
    }

    private static Test makeSuite() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)new BaseTestSuite(RolesConferredPrivilegesTest.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create role a1");
                statement.execute("create role j");
                statement.execute("create role b");
                statement.execute("create role e");
                statement.execute("create role h");
                statement.execute("create role a2");
                statement.execute("create role c");
                statement.execute("create role f");
                statement.execute("create role a3");
                statement.execute("create role d");
                statement.execute("grant a1 to j");
                statement.execute("grant a1 TO b");
                statement.execute("grant b TO e");
                statement.execute("grant e TO h");
                statement.execute("grant a1 TO c");
                statement.execute("grant e TO f");
                statement.execute("grant a2 TO c");
                statement.execute("grant c TO f");
                statement.execute("grant f TO h");
                statement.execute("grant a3 TO d");
                statement.execute("grant d TO f");
                statement.execute("create schema s1");
                statement.execute("create function s1.f1( ) returns int language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.s1f1' no sql called on null input");
                statement.execute("create function s1.f2( ) returns int language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.s1f1' no sql called on null input");
                statement.execute("create table s1.t1(c1 int unique, c2 int unique, c3 int unique, primary key (c1,c2,c3))");
                statement.execute("create procedure s1.calledNested()  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.calledNested'   modifies sql data");
                statement.execute("create function s1.getCurrentRole() returns varchar(30)language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.getCurrentRole'  reads sql data");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.singleProperty(DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, users, pwSuffix), "derby.language.statementCacheSize", "1000"));
    }

    public void atestConferredPrivileges() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String[] stringArray = new String[]{"DonaldDuck", "public"};
        Connection connection2 = this.openUserConnection("DonaldDuck");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            statement.executeUpdate("grant h to " + stringArray[i]);
            String[] stringArray2 = new String[]{"h", "a1", "a2", "a3", "b", "e", "c", "f", "d"};
            String[] stringArray3 = new String[]{"j"};
            this.setRole(connection2, "h");
            for (n = 0; n < stringArray2.length; ++n) {
                this.assertAllforRole(2, connection2, stringArray2[n]);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                this.assertAllforRole(0, connection2, stringArray3[n]);
            }
            this.setRole(connection2, "none");
            for (n = 0; n < stringArray2.length; ++n) {
                this.assertAllforRole(0, connection2, stringArray2[n]);
            }
            statement.executeUpdate("grant f to " + stringArray[i]);
            this.setRole(connection2, "f");
            this.assertAllforRole(2, connection2, "a1");
            statement.executeUpdate("revoke a1 from c");
            this.assertAllforRole(2, connection2, "a1");
            statement.executeUpdate("revoke a1 from b");
            this.assertAllforRole(0, connection2, "a1");
            statement.executeUpdate("grant a1 to b");
            this.assertAllforRole(2, connection2, "a1");
            statement.executeUpdate("grant a1 to c");
            statement.executeUpdate("revoke f from " + stringArray[i]);
            this.setRole(connection2, "h");
            statement.executeUpdate("revoke h from " + stringArray[i]);
            for (n = 0; n < stringArray2.length; ++n) {
                this.assertAllforRole(0, connection2, stringArray2[n]);
            }
            statement.executeUpdate("grant h to " + stringArray[i]);
            this.setRole(connection2, "h");
            for (n = 0; n < stringArray2.length; ++n) {
                this.assertAllforRole(2, connection2, stringArray2[n]);
            }
            statement.executeUpdate("drop role h");
            for (n = 0; n < stringArray2.length; ++n) {
                this.assertAllforRole(0, connection2, stringArray2[n]);
            }
            statement.executeUpdate("create role h");
            statement.executeUpdate("grant e to h");
            statement.executeUpdate("grant f to h");
        }
        connection2.close();
        statement.close();
        connection.close();
    }

    public void testViewInvalidation() throws SQLException {
        SQLWarning sQLWarning;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        String[] stringArray = new String[]{"a2", "h"};
        String[] stringArray2 = new String[]{"DonaldDuck", "public"};
        String[] stringArray3 = new String[]{g_s, g_s_c1};
        String string = "create view v as select c1 from s1.t1";
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                for (int k = 0; k < stringArray3.length; ++k) {
                    statement.executeUpdate("grant h to " + stringArray2[j]);
                    this.doGrantRevoke(0, "test_dbo", stringArray3[k], stringArray[i]);
                    this.setRole(connection2, "h");
                    statement2.executeUpdate(string);
                    this.assertViewExists(true, connection2, "v");
                    this.setRole(connection2, "none");
                    this.assertViewExists(true, connection2, "v");
                    this.doGrantRevoke(1, "test_dbo", stringArray3[k], stringArray[i], VIEWDROPPED);
                    this.assertViewExists(false, connection2, "v");
                    this.doGrantRevoke(0, "test_dbo", stringArray3[k], stringArray[i]);
                    this.setRole(connection2, "h");
                    statement2.executeUpdate(string);
                    this.assertViewExists(true, connection2, "v");
                    statement.executeUpdate("revoke h from " + stringArray2[j]);
                    sQLWarning = statement.getWarnings();
                    RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, sQLWarning);
                    this.assertViewExists(false, connection2, "v");
                    String[] stringArray4 = stringArray2;
                    for (int i2 = 0; i2 < stringArray4.length; ++i2) {
                        statement.executeUpdate("grant h to " + stringArray2[j]);
                        this.doGrantRevoke(0, "test_dbo", stringArray3[k], stringArray4[i2]);
                        this.setRole(connection2, "h");
                        statement2.executeUpdate(string);
                        statement.executeUpdate("revoke h from " + stringArray2[j]);
                        this.assertViewExists(true, connection2, "v");
                        this.doGrantRevoke(1, "test_dbo", stringArray3[k], stringArray4[i2], VIEWDROPPED);
                        this.assertViewExists(false, connection2, "v");
                    }
                    this.doGrantRevoke(1, "test_dbo", stringArray3[k], stringArray[i]);
                }
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        statement2.executeUpdate(string);
        this.assertViewExists(true, connection2, "v");
        statement.executeUpdate("drop role h");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, sQLWarning);
        this.assertViewExists(false, connection2, "v");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        statement.executeUpdate("create role h");
        statement.executeUpdate("grant e to h");
        statement.executeUpdate("grant f to h");
        this.doGrantRevoke(0, "test_dbo", g_s, "a3");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        statement2.executeUpdate(string);
        this.assertViewExists(true, connection2, "v");
        statement.executeUpdate("drop role a3");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, sQLWarning);
        this.assertViewExists(false, connection2, "v");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        statement.executeUpdate("create role a3");
        statement.executeUpdate("grant a3 to d");
        statement2.close();
        connection2.close();
        statement.close();
        connection.close();
    }

    public void testTriggerInvalidation() throws SQLException {
        SQLWarning sQLWarning;
        int n;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        String[] stringArray = new String[]{"a2", "h"};
        String[] stringArray2 = new String[]{"DonaldDuck", "public"};
        String string = "create trigger t after insert on s1.t1 values 1";
        for (int i = 0; i < stringArray.length; ++i) {
            for (n = 0; n < stringArray2.length; ++n) {
                statement.executeUpdate("grant h to " + stringArray2[n]);
                this.doGrantRevoke(0, "test_dbo", g_t, stringArray[i]);
                this.setRole(connection2, "h");
                statement2.executeUpdate(string);
                this.assertTriggerExists(true, connection2, "t");
                statement2.executeUpdate(string);
                this.setRole(connection2, "none");
                this.assertTriggerExists(true, connection2, "t");
                this.setRole(connection2, "h");
                statement2.executeUpdate(string);
                this.doGrantRevoke(1, "test_dbo", g_t, stringArray[i], TRIGGERDROPPED);
                this.assertTriggerExists(false, connection2, "t");
                this.doGrantRevoke(0, "test_dbo", g_t, stringArray[i]);
                this.setRole(connection2, "h");
                statement2.executeUpdate(string);
                this.assertTriggerExists(true, connection2, "t");
                statement2.executeUpdate(string);
                statement.executeUpdate("revoke h from " + stringArray2[n]);
                sQLWarning = statement.getWarnings();
                RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
                this.assertTriggerExists(false, connection2, "t");
                String[] stringArray3 = stringArray2;
                for (int j = 0; j < stringArray3.length; ++j) {
                    statement.executeUpdate("grant h to " + stringArray2[n]);
                    this.doGrantRevoke(0, "test_dbo", g_t, stringArray3[j]);
                    this.setRole(connection2, "h");
                    statement2.executeUpdate(string);
                    statement.executeUpdate("revoke h from " + stringArray2[n]);
                    this.assertTriggerExists(true, connection2, "t");
                    statement2.executeUpdate(string);
                    this.doGrantRevoke(1, "test_dbo", g_t, stringArray3[j], TRIGGERDROPPED);
                    this.assertTriggerExists(false, connection2, "t");
                }
                this.doGrantRevoke(1, "test_dbo", g_t, stringArray[i]);
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_t, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        statement2.executeUpdate(string);
        this.assertTriggerExists(true, connection2, "t");
        statement2.executeUpdate(string);
        statement.executeUpdate("drop role h");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
        this.assertTriggerExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_t, "h");
        statement.executeUpdate("create role h");
        statement.executeUpdate("grant e to h");
        statement.executeUpdate("grant f to h");
        this.doGrantRevoke(0, "test_dbo", g_t, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        statement2.executeUpdate("create trigger t after insert on s1.t1 values s1.f1()");
        this.assertTriggerExists(true, connection2, "t");
        statement2.executeUpdate("create trigger t after insert on s1.t1 values s1.f1()");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
        this.assertTriggerExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_t, "h");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        String[] stringArray4 = new String[]{"h", "DonaldDuck"};
        for (n = 0; n < stringArray4.length; ++n) {
            statement.executeUpdate("grant h to DonaldDuck");
            this.setRole(connection2, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "public");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "h");
            statement2.executeUpdate("create trigger t after insert on s1.t1 select c1,c2 from s1.t1");
            statement.executeUpdate("revoke h from DonaldDuck");
            sQLWarning = statement.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
            this.assertTriggerExists(false, connection2, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "public");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "h");
        }
        for (n = 0; n < stringArray4.length; ++n) {
            statement.executeUpdate("grant h to DonaldDuck");
            this.setRole(connection2, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "h");
            statement2.executeUpdate("create trigger t after insert on s1.t1 select c1,c2 from s1.t1");
            statement.executeUpdate("revoke h from DonaldDuck");
            sQLWarning = statement.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
            this.assertTriggerExists(false, connection2, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "h");
        }
        for (n = 0; n < stringArray4.length; ++n) {
            statement.executeUpdate("grant h to DonaldDuck");
            this.setRole(connection2, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "public");
            this.doGrantRevoke(0, "test_dbo", g_s_c3, "h");
            statement2.executeUpdate("create trigger t after insert on s1.t1 select c1,c2,c3 from s1.t1");
            statement.executeUpdate("revoke h from DonaldDuck");
            sQLWarning = statement.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, sQLWarning);
            this.assertTriggerExists(false, connection2, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, stringArray4[n]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "public");
            this.doGrantRevoke(1, "test_dbo", g_s_c3, "h");
        }
        statement2.close();
        connection2.close();
        statement.close();
        connection.close();
    }

    public void testConstraintInvalidation() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        String[] stringArray = new String[]{"a2", "h"};
        String[] stringArray2 = new String[]{"DonaldDuck", "public"};
        String[][] stringArrayArray = new String[][]{{g_r}, {g_r_c1, g_r_c2, g_r_c3}};
        String string = "create table t (i int not null, j int, k int)";
        String string2 = "drop table t";
        String string3 = "alter table t add constraint fk foreign key(i,j,k) references s1.t1";
        statement2.executeUpdate(string);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                for (int k = 0; k < stringArrayArray.length; ++k) {
                    statement.executeUpdate("grant h to " + stringArray2[j]);
                    this.doGrantRevoke(0, "test_dbo", stringArrayArray[k], stringArray[i]);
                    this.setRole(connection2, "h");
                    statement2.executeUpdate(string3);
                    this.assertFkConstraintExists(true, connection2, "t");
                    this.setRole(connection2, "none");
                    this.assertFkConstraintExists(true, connection2, "t");
                    this.doGrantRevoke(1, "test_dbo", stringArrayArray[k], stringArray[i], new String[]{CONSTRAINTDROPPED, null, null});
                    this.assertFkConstraintExists(false, connection2, "t");
                    this.doGrantRevoke(0, "test_dbo", stringArrayArray[k], stringArray[i]);
                    this.setRole(connection2, "h");
                    statement2.executeUpdate(string3);
                    this.assertFkConstraintExists(true, connection2, "t");
                    statement.executeUpdate("revoke h from " + stringArray2[j]);
                    this.assertFkConstraintExists(false, connection2, "t");
                    String[] stringArray3 = stringArray2;
                    for (int i2 = 0; i2 < stringArray3.length; ++i2) {
                        statement.executeUpdate("grant h to " + stringArray2[j]);
                        this.doGrantRevoke(0, "test_dbo", stringArrayArray[k], stringArray3[i2]);
                        this.setRole(connection2, "h");
                        statement2.executeUpdate(string3);
                        statement.executeUpdate("revoke h from " + stringArray2[j]);
                        this.assertFkConstraintExists(true, connection2, "t");
                        this.doGrantRevoke(1, "test_dbo", stringArrayArray[k], stringArray3[i2], new String[]{CONSTRAINTDROPPED, null, null});
                        this.assertFkConstraintExists(false, connection2, "t");
                    }
                    this.doGrantRevoke(1, "test_dbo", stringArrayArray[k], stringArray[i]);
                }
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_r, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        statement2.executeUpdate(string3);
        this.assertFkConstraintExists(true, connection2, "t");
        statement.executeUpdate("drop role h");
        SQLWarning sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertFkConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        statement.executeUpdate("create role h");
        statement.executeUpdate("grant e to h");
        statement.executeUpdate("grant f to h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", new String[]{g_r_c1, g_r_c2, g_r_c3}, "h");
        statement2.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertFkConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", new String[]{g_r_c1, g_r_c2, g_r_c3}, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "public");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        statement2.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertFkConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "public");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        statement2.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertFkConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "public");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        statement2.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertFkConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "public");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        statement2.executeUpdate("alter table t add constraint ch check(i < s1.f1())");
        this.assertCheckConstraintExists(true, connection2, "t");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertCheckConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        this.doGrantRevoke(0, "test_dbo", g_e_f2, "DonaldDuck");
        statement2.executeUpdate("alter table t add constraint ch check(i < (s1.f1() + s1.f2()))");
        this.assertCheckConstraintExists(true, connection2, "t");
        statement.executeUpdate("revoke h from DonaldDuck");
        sQLWarning = statement.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, sQLWarning);
        this.assertCheckConstraintExists(false, connection2, "t");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        this.doGrantRevoke(1, "test_dbo", g_e_f2, "DonaldDuck");
        statement.executeUpdate("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        this.doGrantRevoke(0, "test_dbo", g_e_f2, "DonaldDuck");
        statement2.executeUpdate("create table tmp(i int constraint ct1 check(i < s1.f1()),                 j int constraint ct2 check(j < s1.f2()))");
        statement.executeUpdate("revoke h from DonaldDuck");
        try {
            statement2.executeUpdate("insert into tmp values (6, -1)");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.fail("expected success", sQLException);
        }
        try {
            statement2.executeUpdate("insert into tmp values (6, 6)");
            RolesConferredPrivilegesTest.fail((String)"ct2 should remain");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(CHECKCONSTRAINTVIOLATED, sQLException);
        }
        statement2.executeUpdate("alter table tmp drop constraint ct2");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        this.doGrantRevoke(1, "test_dbo", g_e_f2, "DonaldDuck");
        statement2.executeUpdate("drop table tmp");
        statement2.executeUpdate(string2);
        statement2.close();
        connection2.close();
        statement.close();
        connection.close();
    }

    public void testMinimumSelectPrivilege() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        Connection connection3 = this.openUserConnection("MickeyMouse");
        Statement statement3 = connection3.createStatement();
        statement.executeUpdate("create role role1");
        statement.executeUpdate("grant role1 to MickeyMouse");
        statement2.executeUpdate("create table DDtable1(c11 int, c12 int)");
        statement2.executeUpdate("insert into DDtable1 values(1, 2)");
        statement2.executeUpdate("create table DDtable2(c21 int, c22 int)");
        statement2.executeUpdate("insert into DDtable2 values(3, 4)");
        statement3.executeUpdate("set role role1");
        try {
            statement3.executeQuery("select c11 from DonaldDuck.DDtable1");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
        }
        try {
            statement3.executeUpdate("update DonaldDuck.DDtable1 set c11 =  (select c21 from DonaldDuck.DDtable2)");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
        }
        statement2.executeUpdate("grant select(c12) on DDtable1 to role1");
        statement2.executeUpdate("grant update on DDtable1 to role1");
        statement3.executeQuery("select c12 from DonaldDuck.DDtable1");
        try {
            statement3.executeQuery("select c11 from DonaldDuck.DDtable1");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
        }
        try {
            statement3.executeUpdate("update DonaldDuck.DDtable1 set c11 =  (select c21 from DonaldDuck.DDtable2)");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
        }
        statement2.executeUpdate("grant select(c11) on DDtable1 to role1");
        statement3.executeQuery("select c12 from DonaldDuck.DDtable1");
        statement3.executeQuery("select c11 from DonaldDuck.DDtable1");
        try {
            statement3.executeQuery("select c11 from DonaldDuck.DDtable1, DonaldDuck.DDtable2");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, sQLException);
        }
        try {
            statement3.executeQuery("update DonaldDuck.DDtable1 set c11 =  (select c21 from DonaldDuck.DDtable2)");
            RolesConferredPrivilegesTest.fail((String)"select should have failed");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
        }
        statement2.executeUpdate("grant select(c21) on DDtable2 to role1");
        statement3.executeQuery("select c12 from DonaldDuck.DDtable1");
        statement3.executeQuery("select c11 from DonaldDuck.DDtable1");
        statement3.executeQuery("select c11 from DonaldDuck.DDtable1, DonaldDuck.DDtable2");
        statement3.executeUpdate("update DonaldDuck.DDtable1 set c11 =  (select c21 from DonaldDuck.DDtable2)");
    }

    public void testPSInvalidation() throws SQLException {
        int n;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        String[] stringArray = new String[]{"a2", "h"};
        String[] stringArray2 = new String[]{"DonaldDuck", "public"};
        String[][] stringArrayArray = new String[][]{{g_s, "select c1 from s1.t1"}, {g_s_c1, "select c1 from s1.t1"}, {g_e, "values s1.f1()"}, {g_u, "update s1.t1 set c1=0"}, {g_u_c1_c2_c3, "update s1.t1 set c1=0"}, {g_i, "insert into s1.t1 values (5,5,5)"}};
        PreparedStatement preparedStatement = null;
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray2.length; ++i) {
                for (int j = 0; j < stringArrayArray.length; ++j) {
                    statement.executeUpdate("grant h to " + stringArray2[i]);
                    this.doGrantRevoke(0, "test_dbo", stringArrayArray[j][0], stringArray[n]);
                    this.setRole(connection2, "h");
                    preparedStatement = connection2.prepareStatement(stringArrayArray[j][1]);
                    this.assertPsWorks(true, preparedStatement);
                    this.setRole(connection2, "none");
                    this.assertPsWorks(false, preparedStatement);
                    this.setRole(connection2, "h");
                    this.assertPsWorks(true, preparedStatement);
                    this.doGrantRevoke(1, "test_dbo", stringArrayArray[j][0], stringArray[n]);
                    this.assertPsWorks(false, preparedStatement);
                    this.doGrantRevoke(0, "test_dbo", stringArrayArray[j][0], stringArray[n]);
                    this.setRole(connection2, "h");
                    this.assertPsWorks(true, preparedStatement);
                    statement.executeUpdate("revoke h from " + stringArray2[i]);
                    this.assertPsWorks(false, preparedStatement);
                    String[] stringArray3 = stringArray2;
                    for (int k = 0; k < stringArray3.length; ++k) {
                        statement.executeUpdate("grant h to " + stringArray2[i]);
                        this.setRole(connection2, "h");
                        this.assertPsWorks(true, preparedStatement);
                        this.doGrantRevoke(0, "test_dbo", stringArrayArray[j][0], stringArray3[k]);
                        statement.executeUpdate("revoke h from " + stringArray2[i]);
                        this.assertPsWorks(true, preparedStatement);
                        this.doGrantRevoke(1, "test_dbo", stringArrayArray[j][0], stringArray3[k]);
                        this.assertPsWorks(false, preparedStatement);
                    }
                    this.doGrantRevoke(1, "test_dbo", stringArrayArray[j][0], stringArray[n]);
                }
            }
        }
        for (n = 0; n < stringArrayArray.length; ++n) {
            this.doGrantRevoke(0, "test_dbo", stringArrayArray[n][0], "h");
            statement.executeUpdate("grant h to DonaldDuck");
            this.setRole(connection2, "h");
            preparedStatement = connection2.prepareStatement(stringArrayArray[n][1]);
            this.assertPsWorks(true, preparedStatement);
            statement.executeUpdate("drop role h");
            this.assertPsWorks(false, preparedStatement);
            this.doGrantRevoke(1, "test_dbo", stringArrayArray[n][0], "h");
            statement.executeUpdate("create role h");
            statement.executeUpdate("grant e to h");
            statement.executeUpdate("grant f to h");
        }
        statement2.close();
        connection2.close();
        statement.close();
        connection.close();
    }

    public void testOpenRs() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        ResultSet resultSet = null;
        String string = "select * from s1.t1";
        PreparedStatement preparedStatement = connection.prepareStatement("insert into s1.t1 values (?,?,?)");
        for (int i = 0; i < 5; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.setInt(3, i);
            preparedStatement.execute();
        }
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        statement.execute("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(false);
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        this.setRole(connection2, "h");
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        connection2.commit();
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(true);
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        statement.execute("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        statement.execute("revoke h from DonaldDuck");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(false);
        statement.execute("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        connection2.commit();
        statement.execute("revoke h from DonaldDuck");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(true);
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        statement.execute("grant h to DonaldDuck");
        this.setRole(connection2, "h");
        connection2.setAutoCommit(true);
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        this.setRole(connection2, "none");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(false);
        this.setRole(connection2, "h");
        resultSet = statement2.executeQuery(string);
        resultSet.next();
        connection2.commit();
        this.setRole(connection2, "none");
        resultSet.next();
        resultSet.close();
        connection2.setAutoCommit(true);
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        statement.executeUpdate("delete from s1.t1");
        connection2.close();
        connection.close();
    }

    public void testDefaultCurrentRole() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("grant h to DonaldDuck");
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        this.setRole(connection2, "h");
        statement2.executeUpdate("create table t(role varchar(128) default current_role)");
        statement2.executeUpdate("insert into t values default");
        ResultSet resultSet = statement2.executeQuery("select * from t");
        JDBC.assertSingleValueResultSet(resultSet, "\"H\"");
        resultSet.close();
        statement2.executeUpdate("drop table t");
        statement2.executeUpdate("create table t(i int)");
        statement2.executeUpdate("insert into t values 1");
        statement2.executeUpdate("alter table t add column role varchar(10) default current_role");
        resultSet = statement2.executeQuery("select * from t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "\"H\""}});
        resultSet.close();
        statement2.executeUpdate("drop table t");
        statement.execute("grant execute on procedure s1.calledNested to DonaldDuck");
        if (!JDBC.vmSupportsJSR169()) {
            statement2.executeUpdate("call s1.calledNested()");
        }
        this.setRole(connection2, "none");
        statement2.close();
        statement.execute("revoke h from DonaldDuck");
        statement.execute("revoke execute on procedure s1.calledNested from DonaldDuck restrict");
        statement.close();
        connection2.close();
        connection.close();
    }

    public void testCurrentRoleInWeirdContexts() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        this.setRole(connection, "a1");
        statement.execute("create table trackCreds(usr varchar(30), role varchar(30))");
        statement.executeUpdate("create table t(i int)");
        statement.execute("grant insert on t to DonaldDuck");
        statement.execute("grant h to DonaldDuck");
        statement.execute("create trigger tr after insert on t insert into trackCreds values (current_user, current_role)");
        Connection connection2 = this.openUserConnection("DonaldDuck");
        Statement statement2 = connection2.createStatement();
        this.setRole(connection2, "h");
        statement2.executeUpdate("insert into test_dbo.t values 1");
        ResultSet resultSet = statement.executeQuery("select * from trackCreds");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"DONALDDUCK", "\"H\""}});
        resultSet.close();
        this.setRole(connection2, "none");
        statement2.close();
        try {
            statement.execute("create table strange(role varchar(30) check (role = current_role))");
            RolesConferredPrivilegesTest.fail((String)"current_role inside a check constraint should be denied");
        }
        catch (SQLException sQLException) {
            RolesConferredPrivilegesTest.assertSQLState(UNRELIABLE, sQLException);
        }
        statement.execute("create table strange(i int)");
        statement.execute("insert into strange values null");
        statement.execute("alter table strange add constraint s check (s1.getCurrentRole() = '\"A1\"')");
        statement.execute("revoke h from DonaldDuck");
        statement.execute("revoke insert on t from DonaldDuck");
        this.setRole(connection, "none");
        statement.execute("drop table t");
        statement.execute("drop table strange");
        statement.execute("drop table trackCreds");
        statement.close();
        connection2.close();
        connection.close();
    }

    public static int s1f1() {
        return 0;
    }

    private void assertAllforRole(int n, Connection connection, String string) throws SQLException {
        for (int i = 0; i < grantRevokes.length; ++i) {
            this.doGrantRevoke(0, "test_dbo", grantRevokes[i], string);
            this.assertEverything(n, connection, null);
            this.doGrantRevoke(1, "test_dbo", grantRevokes[i], string);
            if (n != 2) continue;
            this.assertEverything(0, connection, null);
        }
    }

    private void assertEverything(int n, String string, String string2) throws SQLException {
        Connection connection = this.openUserConnection(string);
        this.assertEverything(n, connection, string2);
        connection.close();
    }

    private void assertEverything(int n, Connection connection, String string) throws SQLException {
        if (string != null) {
            this.setRole(connection, string);
        }
        String[] stringArray = new String[]{"c1", "c2"};
        String string2 = "s1";
        String string3 = "t1";
        String string4 = "f1";
        this.assertSelectPrivilege(n, connection, string2, string3, stringArray);
        this.assertSelectPrivilege(n, connection, string2, string3, null);
        this.assertInsertPrivilege(n, connection, string2, string3, null);
        this.assertUpdatePrivilege(n, connection, string2, string3, stringArray);
        this.assertUpdatePrivilege(n, connection, string2, string3, null);
        this.assertDeletePrivilege(n, connection, string2, string3);
        this.assertReferencesPrivilege(n, connection, string2, string3, stringArray);
        this.assertReferencesPrivilege(n, connection, string2, string3, null);
        this.assertTriggerPrivilege(n, connection, string2, string3);
        this.assertExecutePrivilege(n, connection, string2, string4);
    }

    private void assertExecutePrivilege(int n, String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertExecutePrivilege(n, connection, string3, string4);
        connection.close();
    }

    private void assertExecutePrivilege(int n, Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("values " + string + "." + string2 + "()");
            resultSet.next();
            resultSet.close();
            statement.close();
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no EXECUTE privilege on function. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2)));
            }
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOEXECUTEPERMISSION, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of execute privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2), sQLException);
        }
    }

    private void assertTriggerPrivilege(int n, String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertTriggerPrivilege(n, connection, string3, string4);
        connection.close();
    }

    private void assertTriggerPrivilege(int n, Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        String string3 = string2 + "Trigger";
        try {
            int n2 = statement.executeUpdate("create trigger " + string3 + " after insert on " + string + "." + string2 + " for each row values 1");
            if (n != 0) {
                RolesConferredPrivilegesTest.assertEquals((int)0, (int)n2);
            }
            statement.execute("drop trigger " + string3);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no TRIGGER privilege on table. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of trigger privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2), sQLException);
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "TRIGGER", string, string2, null);
    }

    private void assertReferencesPrivilege(int n, String string, String string2, String string3, String string4, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertReferencesPrivilege(n, connection, string3, string4, stringArray);
        connection.close();
    }

    private void assertReferencesPrivilege(int n, Connection connection, String string, String string2, String[] stringArray) throws SQLException {
        Statement statement = connection.createStatement();
        stringArray = stringArray == null ? this.getAllColumns(string, string2) : stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                statement.execute("create table referencestest (c1 int references " + string + "." + string2 + "(" + stringArray[i] + "))");
                statement.execute("drop table referencestest");
                if (n != 0) continue;
                RolesConferredPrivilegesTest.fail((String)("Unexpected references privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, new String[]{stringArray[i]})));
                continue;
            }
            catch (SQLException sQLException) {
                if (n == 0) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
                    continue;
                }
                RolesConferredPrivilegesTest.fail("Unexpected lack of references privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, new String[]{stringArray[i]}), sQLException);
            }
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "REFERENCES", string, string2, stringArray);
    }

    private void assertUpdatePrivilege(int n, String string, String string2, String string3, String string4, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertUpdatePrivilege(n, connection, string3, string4, stringArray);
        connection.close();
    }

    private void assertUpdatePrivilege(int n, Connection connection, String string, String string2, String[] stringArray) throws SQLException {
        String[] stringArray2 = stringArray == null ? this.getAllColumns(string, string2) : stringArray;
        Statement statement = connection.createStatement();
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl = false;
            try {
                try {
                    ResultSet resultSet = statement.executeQuery("select count(" + stringArray2[i] + ") from " + string + "." + string2);
                    if (!resultSet.next()) {
                        RolesConferredPrivilegesTest.fail((String)("Could not get count on " + stringArray2[i] + " to verify update"));
                    }
                    n2 = resultSet.getInt(1);
                    bl = true;
                }
                catch (SQLException sQLException) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
                }
                int n3 = statement.executeUpdate("update " + string + "." + string2 + " set " + stringArray2[i] + "= 0");
                if (n != 0 && bl) {
                    RolesConferredPrivilegesTest.assertEquals((int)n2, (int)n3);
                }
                if (n != 0) continue;
                RolesConferredPrivilegesTest.fail((String)("expected no UPDATE privilege on  " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, new String[]{stringArray2[i]})));
                continue;
            }
            catch (SQLException sQLException) {
                if (n == 0) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, sQLException);
                    continue;
                }
                RolesConferredPrivilegesTest.fail((String)("Unexpected lack of privilege to update. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, new String[]{stringArray2[i]})));
            }
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "UPDATE", string, string2, stringArray);
    }

    private void assertInsertPrivilege(int n, String string, String string2, String string3, String string4, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertInsertPrivilege(n, connection, string3, string4, stringArray);
        connection.close();
    }

    private void assertInsertPrivilege(int n, Connection connection, String string, String string2, String[] stringArray) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            int n2 = statement.executeUpdate("insert into " + string + "." + string2 + " values (0,0,0)");
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no INSERT privilege on table, " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of insert privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray), sQLException);
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "INSERT", string, string2, stringArray);
    }

    private void assertSelectPrivilege(int n, String string, String string2, String string3, String string4, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertSelectPrivilege(n, connection, string3, string4, stringArray);
        connection.close();
    }

    private void assertSelectPrivilege(int n, Connection connection, String string, String string2, String[] stringArray) throws SQLException {
        this.assertSelectPrivilege(n, connection, string, string2, stringArray, NOCOLUMNPERMISSION);
        this.assertSelectConstantPrivilege(n, connection, string, string2, NOTABLEPERMISSION);
        this.assertSelectCountPrivilege(n, connection, string, string2, stringArray, NOTABLEPERMISSION);
    }

    private void assertSelectCountPrivilege(int n, Connection connection, String string, String string2, String[] stringArray, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("select count(*) from " + string + "." + string2);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no SELECT privilege on table " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(string3, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of select privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray), sQLException);
        }
        try {
            statement.execute("select count('a') from " + string + "." + string2);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no SELECT privilege on table " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(string3, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of select privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray), sQLException);
        }
        statement.close();
    }

    private void assertSelectConstantPrivilege(int n, Connection connection, String string, String string2, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("select 1 from " + string + "." + string2);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no SELECT privilege on table " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(string3, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of select privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2), sQLException);
        }
        statement.close();
    }

    private void assertSelectPrivilege(int n, Connection connection, String string, String string2, String[] stringArray, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("select " + RolesConferredPrivilegesTest.columnListAsString(stringArray) + " from " + string + "." + string2);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no SELECT privilege on table " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(string3, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of select privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2, stringArray), sQLException);
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "SELECT", string, string2, stringArray);
    }

    private void assertViewExists(boolean bl, Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("select * from " + string);
            if (!bl) {
                RolesConferredPrivilegesTest.fail((String)("Table expected not to exist: " + string));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                RolesConferredPrivilegesTest.fail("Table expected to exist: " + string, sQLException);
            }
            RolesConferredPrivilegesTest.assertSQLState(TABLENOTFOUND, sQLException);
        }
        statement.close();
    }

    private void assertTriggerExists(boolean bl, Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop trigger " + string);
            if (!bl) {
                RolesConferredPrivilegesTest.fail((String)("Trigger expected not to exist: " + string));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                RolesConferredPrivilegesTest.fail("Trigger expected to exist: " + string, sQLException);
            }
            RolesConferredPrivilegesTest.assertSQLState(OBJECTNOTFOUND, sQLException);
        }
        statement.close();
    }

    private void assertFkConstraintExists(boolean bl, Connection connection, String string) throws SQLException {
        this.assertConstraintExists(bl, connection, string, FKVIOLATION);
    }

    private void assertCheckConstraintExists(boolean bl, Connection connection, String string) throws SQLException {
        this.assertConstraintExists(bl, connection, string, CHECKCONSTRAINTVIOLATED);
    }

    private void assertConstraintExists(boolean bl, Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("insert into " + string + " values (6,6,6)");
            statement.execute("delete from " + string);
            if (bl) {
                RolesConferredPrivilegesTest.fail((String)("Table expected to have a constraint: " + string));
            }
        }
        catch (SQLException sQLException) {
            if (!bl) {
                RolesConferredPrivilegesTest.fail("Table expected not to have a constraint: " + string, sQLException);
            }
            RolesConferredPrivilegesTest.assertSQLState(string2, sQLException);
        }
        statement.close();
    }

    private void assertPsWorks(boolean bl, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.getConnection().setAutoCommit(false);
        try {
            boolean bl2 = preparedStatement.execute();
            ResultSet resultSet = preparedStatement.getResultSet();
            if (resultSet != null) {
                resultSet.next();
                resultSet.close();
            }
            preparedStatement.getConnection().rollback();
            preparedStatement.getConnection().setAutoCommit(true);
            if (!bl) {
                RolesConferredPrivilegesTest.fail((String)"Prepared statement expected to fail.");
            }
        }
        catch (SQLException sQLException) {
            preparedStatement.getConnection().setAutoCommit(true);
            if (bl) {
                RolesConferredPrivilegesTest.fail("Prepared statement expected to work.", sQLException);
            }
            this.assertSQLState(new String[]{NOCOLUMNPERMISSION, NOEXECUTEPERMISSION, NOTABLEPERMISSION}, sQLException);
        }
    }

    private void assertDeletePrivilege(int n, String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = this.openUserConnection(string);
        if (string2 != null) {
            this.setRole(connection, string2);
        }
        this.assertDeletePrivilege(n, connection, string3, string4);
        connection.close();
    }

    private void assertDeletePrivilege(int n, Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("delete from " + string + "." + string2);
            if (n == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no DELETE privilege on table " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2)));
            }
        }
        catch (SQLException sQLException) {
            if (n == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, sQLException);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of delete privilege. " + RolesConferredPrivilegesTest.formatArgs(connection, string, string2), sQLException);
        }
        statement.close();
        this.assertPrivilegeMetadata(n, connection, "DELETE", string, string2, null);
    }

    private void assertPrivilegeMetadata(int n, Connection connection, String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values current_user");
        resultSet.next();
        String string4 = resultSet.getString(1);
        resultSet.close();
        statement.close();
        if (this.isOwner(string2, string4)) {
            return;
        }
        if (n == 2) {
            return;
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        resultSet = databaseMetaData.getTablePrivileges(null, JDBC.identifierToCNF(string2), JDBC.identifierToCNF(string3));
        boolean bl = false;
        if (stringArray == null) {
            while (resultSet.next()) {
                RolesConferredPrivilegesTest.assertEquals((String)JDBC.identifierToCNF("test_dbo"), (String)resultSet.getString(4));
                RolesConferredPrivilegesTest.assertEquals((String)"NO", (String)resultSet.getString(7));
                if (!resultSet.getString(6).equals(string) || !((String)(object = resultSet.getString(5))).equals(string4) && !((String)object).equals(JDBC.identifierToCNF("public"))) continue;
                bl = true;
            }
            RolesConferredPrivilegesTest.assertEquals((n == 1 ? 1 : 0) != 0, (boolean)bl);
            resultSet.close();
        }
        object = null;
        if (stringArray != null) {
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                object = databaseMetaData.getColumnPrivileges(null, JDBC.identifierToCNF(string2), JDBC.identifierToCNF(string3), JDBC.identifierToCNF(stringArray[i]));
                while (object.next()) {
                    String string5;
                    RolesConferredPrivilegesTest.assertEquals((String)JDBC.identifierToCNF("test_dbo"), (String)object.getString(5));
                    RolesConferredPrivilegesTest.assertEquals((String)"NO", (String)object.getString(8));
                    if (!object.getString(7).equals(string) || !(string5 = object.getString(6)).equals(string4) && !string5.equals(JDBC.identifierToCNF("public"))) continue;
                    ++n2;
                }
            }
            if (n == 1) {
                RolesConferredPrivilegesTest.assertEquals((int)stringArray.length, (int)n2);
            } else {
                RolesConferredPrivilegesTest.assertEquals((int)0, (int)n2);
            }
        }
        if (object != null) {
            object.close();
        }
    }

    private boolean isOwner(String string, String string2) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select schemaname, authorizationid from sys.sysschemas where schemaname='" + JDBC.identifierToCNF(string) + "'");
        resultSet.next();
        boolean bl = resultSet.getString(2).equals(JDBC.identifierToCNF(string2));
        resultSet.close();
        statement.close();
        return bl;
    }

    private String[] getAllColumns(String string, String string2) throws SQLException {
        Connection connection = this.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, null);
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(4));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String columnListAsString(String[] stringArray) {
        if (stringArray == null) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("," + stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static String formatArgs(Connection connection, String string, String string2, String[] stringArray) throws SQLException {
        return RolesConferredPrivilegesTest.formatArgs(connection, string, string2) + "(" + RolesConferredPrivilegesTest.columnListAsString(stringArray) + ")";
    }

    private static String formatArgs(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values current_user");
        resultSet.next();
        String string3 = resultSet.getString(1);
        resultSet = connection.createStatement().executeQuery("values current_role");
        resultSet.next();
        String string4 = resultSet.getString(1);
        resultSet.close();
        statement.close();
        return "User: " + string3 + (String)(string4 == null ? "" : " Role: " + string4) + " Object: " + string + "." + string2;
    }

    private void setRole(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (string.toUpperCase().equals("NONE")) {
            preparedStatement = connection.prepareStatement("set role none");
        } else {
            preparedStatement = connection.prepareStatement("set role ?");
            preparedStatement.setString(1, string);
        }
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void doGrantRevoke(int n, String string, String[] stringArray, String string2, String[] stringArray2) throws SQLException {
        Connection connection = this.openUserConnection(string);
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            statement.execute((n == 0 ? "grant " : "revoke ") + stringArray[i] + (n == 0 ? " to " : " from ") + string2 + (n == 1 && stringArray[i].startsWith("execute") ? " restrict" : ""));
            if (stringArray2[i] == null) continue;
            RolesConferredPrivilegesTest.assertSQLState(stringArray2[i], statement.getWarnings());
        }
        statement.close();
        connection.close();
    }

    private void doGrantRevoke(int n, String string, String[] stringArray, String string2) throws SQLException {
        String[] stringArray2 = new String[stringArray.length];
        this.doGrantRevoke(n, string, stringArray, string2, stringArray2);
    }

    private void doGrantRevoke(int n, String string, String string2, String string3, String string4) throws SQLException {
        this.doGrantRevoke(n, string, new String[]{string2}, string3, new String[]{string4});
    }

    private void doGrantRevoke(int n, String string, String string2, String string3) throws SQLException {
        this.doGrantRevoke(n, string, new String[]{string2}, string3);
    }

    private String CNFUser2user(String string) {
        for (int i = 0; i < users.length; ++i) {
            if (!JDBC.identifierToCNF(users[i]).equals(string)) continue;
            return users[i];
        }
        RolesConferredPrivilegesTest.fail((String)"test error");
        return null;
    }

    private void assertSQLState(String[] stringArray, SQLException sQLException) {
        String string = sQLException.getSQLState();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Exception ");
            stringBuffer.append(string);
            stringBuffer.append(" found, one of ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append('|');
            }
            stringBuffer.append(" expected");
            RolesConferredPrivilegesTest.fail((String)stringBuffer.toString());
        }
    }

    public static void calledNested() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            Statement statement = connection.createStatement();
            statement.executeUpdate("create table t(role varchar(128) default current_role)");
            statement.executeUpdate("insert into t values default");
            ResultSet resultSet = statement.executeQuery("select * from t");
            JDBC.assertSingleValueResultSet(resultSet, "\"H\"");
            resultSet.close();
            statement.executeUpdate("drop table t");
            statement.executeUpdate("create table t(i int)");
            statement.executeUpdate("insert into t values 1");
            statement.executeUpdate("alter table t add column role varchar(10) default current_role");
            resultSet = statement.executeQuery("select * from t");
            JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "\"H\""}});
            resultSet.close();
            statement.executeUpdate("drop table t");
            statement.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentRole() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("values current_role");
            resultSet.next();
            String string = resultSet.getString(1);
            resultSet.close();
            statement.close();
            String string2 = string;
            return string2;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

