/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SimpleJsonTest
extends BaseJDBCTestCase {
    private static final String TAB = "  ";
    private static final String USER_ERROR = "38000";
    private static final String OUT_OF_RANGE = "22003";
    private static final String THERMOSTAT_READINGS = "[\n {\n   \"id\": 1,\n   \"temperature\": 70.3,\n   \"fanOn\": true\n },\n {\n   \"id\": 2,\n   \"temperature\": 65.5,\n   \"fanOn\": false\n }\n]";

    public SimpleJsonTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SimpleJsonTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(SimpleJsonTest.class));
        return new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/lang/thermostatReadings.dat", "functionTests/tests/lang/json.dat"});
    }

    public void testBasic_001() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.createSchema_001(connection);
        this.assertResults(connection, "values prettyPrint( toJSON( 'select * from thermostatReadings order by \"id\", \"sampleTime\"' ) )", new String[][]{{"[\n  {\n    \"fanOn\" : false, \n    \"id\" : 1, \n    \"sampleTime\" : \"2015-07-08 04:03:20.0\", \n    \"temperature\" : 65.5\n  }, \n  {\n    \"fanOn\" : true, \n    \"id\" : 1, \n    \"sampleTime\" : \"2015-07-08 13:03:20.0\", \n    \"temperature\" : 70.1\n  }, \n  {\n    \"fanOn\" : false, \n    \"id\" : 2, \n    \"sampleTime\" : \"2015-07-08 03:03:20.0\", \n    \"temperature\" : 64.5\n  }, \n  {\n    \"fanOn\" : true, \n    \"id\" : 2, \n    \"sampleTime\" : \"2015-07-08 16:03:20.0\", \n    \"temperature\" : 72.1\n  }\n]"}}, true);
        this.assertResults(connection, "values prettyPrint( toJSON( 'select \"id\", max( \"temperature\" ) \"maxTemp\" from thermostatReadings group by \"id\"' ) )", new String[][]{{"[\n  {\n    \"id\" : 1, \n    \"maxTemp\" : 70.1\n  }, \n  {\n    \"id\" : 2, \n    \"maxTemp\" : 72.1\n  }\n]"}}, true);
        this.assertResults(connection, "values prettyPrint( toJSON( 'select \"id\", max( \"temperature\" ) \"maxTemp\" from thermostatReadings where \"id\" = ? group by \"id\"', '2' ) )", new String[][]{{"[\n  {\n    \"id\" : 2, \n    \"maxTemp\" : 72.1\n  }\n]"}}, true);
        this.dropSchema_001(connection);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    private void createSchema_001(Connection connection) throws Exception {
        this.goodStatement(connection, "create table thermostatReadings\n(\n\"id\" int,\n\"temperature\" double,\n\"fanOn\" boolean,\n\"sampleTime\" timestamp,\nprimary key( \"id\", \"sampleTime\" )\n)\n");
        this.goodStatement(connection, "insert into thermostatReadings values\n( 1, 65.5, false, timestamp( '2015-07-08 04:03:20') ),\n( 1, 70.1, true, timestamp( '2015-07-08 13:03:20') ),\n( 2, 64.5, false, timestamp( '2015-07-08 03:03:20') ),\n( 2, 72.1, true, timestamp( '2015-07-08 16:03:20') )\n");
        this.goodStatement(connection, "create function prettyPrint( doc JSONArray ) returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".prettyPrint'\n");
    }

    private void dropSchema_001(Connection connection) throws Exception {
        this.goodStatement(connection, "drop function prettyPrint");
        this.goodStatement(connection, "drop table thermostatReadings");
    }

    public void testDatatypes_002() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.createSchema_002(connection);
        this.assertResults(connection, "values( prettyPrint( toJSON( 'select * from all_types order by key_col' ) ) )", new String[][]{{"[\n  {\n    \"BIGINT_COL\" : 0, \n    \"BLOB_COL\" : \"01\", \n    \"CHAR_COL\" : \"0         \", \n    \"CHAR_FOR_BIT_DATA_COL\" : \"de202020202020202020\", \n    \"CLOB_COL\" : \"0\", \n    \"DATE_COL\" : \"1994-02-23\", \n    \"DECIMAL_COL\" : 0.0, \n    \"DOUBLE_COL\" : 0.0, \n    \"INT_COL\" : 0, \n    \"JSON_ARRAY_COL\" : [\n      {\n        \"A\" : 1, \n        \"B\" : true\n      }, \n      {\n        \"A\" : 2, \n        \"B\" : false\n      }\n    ], \n    \"KEY_COL\" : 0, \n    \"LONG_VARCHAR_COL\" : \"0\", \n    \"LONG_VARCHAR_FOR_BIT_DATA_COL\" : \"de\", \n    \"NUMERIC_COL\" : 0.0, \n    \"PRICE_COL\" : \"Price( USD, 9.99000, 2009-10-16 14:24:43.0 )\", \n    \"REAL_COL\" : 0.0, \n    \"SMALLINT_COL\" : 0, \n    \"TIMESTAMP_COL\" : \"1962-09-23 03:23:34.234\", \n    \"TIME_COL\" : \"15:09:02\", \n    \"VARCHAR_COL\" : \"0\", \n    \"VARCHAR_FOR_BIT_DATA_COL\" : \"de\"\n  }, \n  {\n    \"BIGINT_COL\" : null, \n    \"BLOB_COL\" : null, \n    \"CHAR_COL\" : null, \n    \"CHAR_FOR_BIT_DATA_COL\" : null, \n    \"CLOB_COL\" : null, \n    \"DATE_COL\" : null, \n    \"DECIMAL_COL\" : null, \n    \"DOUBLE_COL\" : null, \n    \"INT_COL\" : null, \n    \"JSON_ARRAY_COL\" : null, \n    \"KEY_COL\" : 1, \n    \"LONG_VARCHAR_COL\" : null, \n    \"LONG_VARCHAR_FOR_BIT_DATA_COL\" : null, \n    \"NUMERIC_COL\" : null, \n    \"PRICE_COL\" : null, \n    \"REAL_COL\" : null, \n    \"SMALLINT_COL\" : null, \n    \"TIMESTAMP_COL\" : null, \n    \"TIME_COL\" : null, \n    \"VARCHAR_COL\" : null, \n    \"VARCHAR_FOR_BIT_DATA_COL\" : null\n  }\n]"}}, true);
        this.dropSchema_002(connection);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    private void createSchema_002(Connection connection) throws Exception {
        this.goodStatement(connection, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp )\nreturns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.goodStatement(connection, "create function makeSimpleBlob( ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.makeSimpleBlob'\n");
        this.goodStatement(connection, "create table dummy( a int, b boolean )");
        this.goodStatement(connection, "insert into dummy values ( 1, true ), ( 2, false )");
        this.goodStatement(connection, "create table all_types\n(\n    key_col int,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB(2147483647),\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2),\n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA,\n    price_col price,\n    json_array_col jsonArray\n)\n");
        this.goodStatement(connection, "insert into all_types( key_col ) values ( 1 )");
        this.goodStatement(connection, "insert into all_types\n(\n    key_col,\n    bigint_col,\n    blob_col,\n    char_col,\n    char_for_bit_data_col,\n    clob_col,\n    date_col,\n    decimal_col,\n    real_col,\n    double_col,\n    int_col,\n    long_varchar_col,\n    long_varchar_for_bit_data_col,\n    numeric_col,\n    smallint_col,\n    time_col,\n    timestamp_col,\n    varchar_col,\n    varchar_for_bit_data_col,\n    price_col,\n    json_array_col\n)\nvalues\n(\n    0,\n    0,\n    makeSimpleBlob(),\n    '0',\n    X'DE',\n    '0',\n    date('1994-02-23'),\n    0.00,\n    0.0,\n    0.0,\n    0,\n    '0',\n    X'DE',\n    0.00,\n    0,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '0',\n    X'DE',\n    makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') ),\n    toJSON( 'select * from dummy order by a' ) \n)\n");
        this.goodStatement(connection, "create function prettyPrint( doc JSONArray ) returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.SimpleJsonTest.prettyPrint'\n");
    }

    private void dropSchema_002(Connection connection) throws Exception {
        this.goodStatement(connection, "drop function makePrice");
        this.goodStatement(connection, "drop function makeSimpleBlob");
        this.goodStatement(connection, "drop table all_types");
        this.goodStatement(connection, "drop type price restrict");
        this.goodStatement(connection, "drop function prettyPrint");
    }

    public void testNegative_003() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.expectExecutionError(connection, USER_ERROR, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
        this.expectExecutionError(connection, USER_ERROR, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.expectExecutionError(connection, USER_ERROR, "values( toJSON( 'select * from sys.systables where tablename = ?' ) )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    public void testVTI_004() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.goodStatement(connection, "create function thermostatReadings( jsonDocument JSONArray )\nreturns table\n(\n\"id\" int,\n\"temperature\" float,\n\"fanOn\" boolean\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonVTI.readArray'\n");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from table\n( thermostatReadings( readArrayFromString(?) ) ) t order by \"id\"");
        preparedStatement.setString(1, THERMOSTAT_READINGS);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, new String[][]{{"1", "70.3", "true"}, {"2", "65.5", "false"}}, true);
        resultSet.close();
        preparedStatement.close();
        File file = SupportFilesSetup.getReadOnly("thermostatReadings.dat");
        String[][] stringArray = new String[][]{{"1", "70.3", "true"}, {"2", "65.5", "false"}, {"3", "60.5", "false"}};
        preparedStatement = connection.prepareStatement("select * from table\n( thermostatReadings( readArrayFromFile( ?, 'UTF-8' ) ) ) t order by \"id\"");
        preparedStatement.setString(1, PrivilegedFileOpsForTests.getAbsolutePath(file));
        resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray, true);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select * from table\n( thermostatReadings( readArrayFromURL( ?, 'UTF-8' ) ) ) t order by \"id\"");
        String string = PrivilegedFileOpsForTests.toURI(file).toURL().toString();
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray, true);
        resultSet.close();
        preparedStatement.close();
        this.goodStatement(connection, "drop function thermostatReadings");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    public void testVTIdatatypes005() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.vetDatatype_005(connection, "smallint", new String[][]{{"abc", "true", "127"}, {"def", "false", "1"}, {"ghi", null, "345"}, {"lmn", "true", "-1"}});
        this.vetDatatype_005(connection, "int", new String[][]{{"abc", "true", "127"}, {"def", "false", "1"}, {"ghi", null, "345"}, {"lmn", "true", "-1"}});
        this.vetDatatype_005(connection, "bigint", new String[][]{{"abc", "true", "127"}, {"def", "false", "1"}, {"ghi", null, "345"}, {"lmn", "true", "9223372036854775807"}});
        this.vetDatatype_005(connection, "float", new String[][]{{"abc", "true", "127.0"}, {"def", "false", "1.2"}, {"ghi", null, "345.67"}, {"lmn", "true", "9.223372036854776E18"}});
        this.vetDatatype_005(connection, "double", new String[][]{{"abc", "true", "127.0"}, {"def", "false", "1.2"}, {"ghi", null, "345.67"}, {"lmn", "true", "9.223372036854776E18"}});
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    private void vetDatatype_005(Connection connection, String string, String[][] stringArray) throws Exception {
        this.createFunction_005(connection, string);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from table\n( f_" + string + "( readArrayFromFile( ?, 'UTF-8' ) )) t\n");
        File file = SupportFilesSetup.getReadOnly("json.dat");
        preparedStatement.setString(1, PrivilegedFileOpsForTests.getAbsolutePath(file));
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray, true);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        SimpleJsonTest.assertEquals((byte)127, (byte)resultSet.getByte("NUM_COL"));
        resultSet.next();
        SimpleJsonTest.assertEquals((byte)1, (byte)resultSet.getByte("NUM_COL"));
        resultSet.close();
        preparedStatement.close();
        this.dropFunction_005(connection, string);
    }

    private void createFunction_005(Connection connection, String string) throws Exception {
        this.goodStatement(connection, "create function f_" + string + "( jsonArray JSONArray )\nreturns table\n(\n  str_col varchar( 10 ),\n  bool_col boolean,\n  num_col " + string + "\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonVTI.readArray'\n");
    }

    private void dropFunction_005(Connection connection, String string) throws Exception {
        this.goodStatement(connection, "drop function f_" + string);
    }

    public void testArrayToClob_006() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', true )");
        this.goodStatement(connection, "create table employee( fullName varchar( 100 ) )");
        this.goodStatement(connection, "create table docs( stringDoc varchar( 32672 ) )");
        this.goodStatement(connection, "insert into employee values ( 'Fred Flintstone' ), ( 'Barney Rubble' )");
        this.goodStatement(connection, "insert into docs values( arrayToClob( toJSON( 'select * from employee' ) ) )");
        this.assertResults(connection, "select * from docs", new String[][]{{"[{\"FULLNAME\":\"Fred Flintstone\"},{\"FULLNAME\":\"Barney Rubble\"}]"}}, true);
        this.goodStatement(connection, "drop table docs");
        this.goodStatement(connection, "drop table employee");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'simpleJson', false )");
    }

    public static String prettyPrint(JSONArray jSONArray) {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleJsonTest.prettyPrintArray(stringBuilder, 0, jSONArray);
        return stringBuilder.toString();
    }

    private static void prettyPrintArray(StringBuilder stringBuilder, int n, JSONArray jSONArray) {
        stringBuilder.append("[");
        int n2 = jSONArray.size();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                SimpleJsonTest.indent(stringBuilder, n + 1);
                SimpleJsonTest.prettyPrint(stringBuilder, n + 1, jSONArray.get(i));
            }
            SimpleJsonTest.indent(stringBuilder, n);
        }
        stringBuilder.append("]");
    }

    private static void prettyPrintObject(StringBuilder stringBuilder, int n, JSONObject jSONObject) {
        stringBuilder.append("{");
        int n2 = jSONObject.size();
        if (n2 > 0) {
            Object[] objectArray = jSONObject.keySet().toArray();
            Arrays.sort(objectArray);
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray[i];
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                SimpleJsonTest.indent(stringBuilder, n + 1);
                stringBuilder.append(SimpleJsonTest.doubleQuote((String)object));
                stringBuilder.append(" : ");
                SimpleJsonTest.prettyPrint(stringBuilder, n + 1, jSONObject.get(object));
            }
            SimpleJsonTest.indent(stringBuilder, n);
        }
        stringBuilder.append("}");
    }

    private static void prettyPrint(StringBuilder stringBuilder, int n, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof JSONArray) {
            SimpleJsonTest.prettyPrintArray(stringBuilder, n, (JSONArray)object);
        } else if (object instanceof JSONObject) {
            SimpleJsonTest.prettyPrintObject(stringBuilder, n, (JSONObject)object);
        } else if (object instanceof Number || object instanceof Boolean) {
            stringBuilder.append(object.toString());
        } else {
            stringBuilder.append(SimpleJsonTest.doubleQuote(object.toString()));
        }
    }

    private static void indent(StringBuilder stringBuilder, int n) {
        stringBuilder.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(TAB);
        }
    }

    private static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }
}

