/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_FileSystemData
extends T_MultiThreadedIterations {
    private static final String testService = "fileSystemDataTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static RawStoreFactory factory;
    static LockFactory lf;
    static long commonContainer;
    static boolean testRollback;
    static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static ContextService contextService;
    private T_Util t_util;

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        contextService = T_FileSystemData.getContextService();
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        String string = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        boolean bl = testRollback = Boolean.valueOf(string) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        try {
            factory = (RawStoreFactory)T_FileSystemData.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        this.t_util = new T_Util(factory, lf, contextService);
        commonContainer = this.commonContainer();
    }

    @Override
    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        T_Fail.T_ASSERT(commonContainer != -1L, "common container not setup ");
        this.t_util = new T_Util(factory, lf, contextService);
    }

    @Override
    protected T_MultiThreadedIterations newTestObject() {
        return new T_FileSystemData();
    }

    @Override
    protected void runTestSet() throws T_Fail {
        ContextManager contextManager = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager);
        try {
            this.runCostEstimationTests();
            this.runAllocationTests();
        }
        catch (StandardException standardException) {
            contextManager.cleanupOnError((Throwable)standardException, false);
            throw T_Fail.exceptionFail(standardException);
        }
        finally {
            contextService.resetCurrentContextManager(contextManager);
        }
    }

    private long commonContainer() throws T_Fail {
        long l;
        ContextManager contextManager = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager);
        try {
            Transaction transaction = this.t_util.t_startTransaction();
            l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        catch (StandardException standardException) {
            contextManager.cleanupOnError((Throwable)standardException, false);
            throw T_Fail.exceptionFail(standardException);
        }
        finally {
            contextService.resetCurrentContextManager(contextManager);
        }
        return l;
    }

    protected void runCostEstimationTests() throws T_Fail, StandardException {
        this.CostEstimationTest1();
    }

    protected void runAllocationTests() throws T_Fail, StandardException {
        if (this.threadNumber < 2) {
            this.AllocTest1();
            this.AllocTest2();
            this.AllocTest3();
            this.AllocTest4();
        }
        this.AllocMTest1(commonContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CostEstimationTest1() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        try {
            int n = 10;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            RecordHandle[] recordHandleArray = new RecordHandle[n];
            for (int i = 0; i < n; ++i) {
                recordHandleArray[i] = this.t_util.t_insert(containerHandle, t_RawStoreRow);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            if (containerHandle.getEstimatedRowCount(0) != (long)n && containerHandle.getEstimatedRowCount(0) != (long)(n - 1)) {
                throw T_Fail.testFailMsg("expect estimated row count to be " + (n - 1) + " or " + n + ", got " + containerHandle.getEstimatedRowCount(0));
            }
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_007);
            for (int i = 0; i < n; ++i) {
                this.t_util.t_update(containerHandle, recordHandleArray[i], t_RawStoreRow2);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            if (containerHandle.getEstimatedRowCount(0) != (long)n && containerHandle.getEstimatedRowCount(0) != (long)n && containerHandle.getEstimatedRowCount(0) != (long)(n - 1)) {
                throw T_Fail.testFailMsg("expect after update same estimated row count, but it is not.expect estimated row count to be " + (n - 1) + " or " + n + ", got " + containerHandle.getEstimatedRowCount(0));
            }
            containerHandle.setEstimatedRowCount((long)(2 * n), 0);
            if (containerHandle.getEstimatedRowCount(0) != (long)(2 * n)) {
                throw T_Fail.testFailMsg("forcibly setting estimated row count doesn't seem to work");
            }
            Page page = null;
            long l2 = 0L;
            long l3 = 0L;
            page = containerHandle.getFirstPage();
            while (page != null) {
                int n2 = page.recordCount() / 3;
                l2 = page.getPageNumber();
                page.deleteAtSlot(0, true, (LogicalUndo)null);
                page.purgeAtSlot(n2, n2, true);
                l3 += (long)(n2 + 1);
                page.unlatch();
                page = containerHandle.getNextPage(l2);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            if (containerHandle.getEstimatedRowCount(0) != (long)(2 * n) - l3) {
                throw T_Fail.testFailMsg("expect " + ((long)(2 * n) - l3) + " after purge");
            }
            this.REPORT("before page delete, estRC = " + 2 * n + " - " + l3);
            page = containerHandle.getFirstPage();
            while (page != null) {
                l2 = page.getPageNumber();
                if (l2 % 2L == 0L) {
                    l3 += (long)page.nonDeletedRecordCount();
                    containerHandle.removePage(page);
                } else {
                    page.unlatch();
                }
                page = containerHandle.getNextPage(l2);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            if (containerHandle.getEstimatedRowCount(0) != (long)(2 * n) - l3) {
                throw T_Fail.testFailMsg("expect " + ((long)(2 * n) - l3) + " after page remove, got " + containerHandle.getEstimatedRowCount(0));
            }
            this.PASS("CostEstimationTest1");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest1() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n;
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            long l2 = page.getPageNumber();
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page, t_RawStoreRow);
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            int n2 = T_Util.t_insert(page2, t_RawStoreRow2).getId();
            Page page3 = this.t_util.t_addPage(containerHandle);
            long l4 = page3.getPageNumber();
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_Util.t_insert(page3, t_RawStoreRow3);
            Page page4 = this.t_util.t_addPage(containerHandle);
            long l5 = page4.getPageNumber();
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            int n3 = T_Util.t_insert(page4, t_RawStoreRow4).getId();
            Page page5 = this.t_util.t_addPage(containerHandle);
            long l6 = page5.getPageNumber();
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            T_Util.t_insert(page5, t_RawStoreRow5);
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_removePage(containerHandle, page4);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page6 = containerHandle.getFirstPage();
            if (page6 == null) {
                throw T_Fail.testFailMsg("get first page failed: expect " + l2 + " got null");
            }
            if (page6.getPageNumber() != l2) {
                throw T_Fail.testFailMsg("get first page failed: expect " + l2 + " got " + page6.getPageNumber());
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page6 = containerHandle.getNextPage(l2);
            if (page6 == null || page6.getPageNumber() != l4) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page6 = containerHandle.getNextPage(l4);
            if (page6 == null || page6.getPageNumber() != l6) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page6 = this.t_util.t_getLastPage(containerHandle);
            if (page6 == null || page6.getPageNumber() != l6) {
                throw T_Fail.testFailMsg("getLastPage failed");
            }
            this.t_util.t_commit(transaction);
            int n4 = 100;
            T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(REC_001);
            long[] lArray = new long[n4];
            int[] nArray = new int[n4];
            lArray[0] = l3;
            nArray[0] = n2;
            lArray[1] = l5;
            nArray[1] = n3;
            int n5 = -1;
            for (n = 2; n5 < 0 && n < n4; ++n) {
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                page6 = this.t_util.t_addPage(containerHandle);
                lArray[n] = page6.getPageNumber();
                for (int i = 0; i < n - 1; ++i) {
                    if (lArray[i] != lArray[n]) continue;
                    n5 = i;
                    break;
                }
                if (n5 >= 0) {
                    T_Util.t_checkEmptyPage(page6);
                    RecordHandle recordHandle = T_Util.t_insert(page6, t_RawStoreRow6);
                    if (recordHandle.getId() != nArray[n5]) break;
                    throw T_Fail.testFailMsg("reused page recordId is not preserved");
                }
                nArray[n] = T_Util.t_insert(page6, t_RawStoreRow6).getId();
                this.t_util.t_removePage(containerHandle, page6);
                this.t_util.t_commit(transaction);
            }
            this.t_util.t_dropContainer(transaction, 0L, l);
            if (n5 >= 0) {
                this.PASS("AllocTest1 success in " + n + " tries");
            } else {
                this.REPORT("AllocTest1 Not successful in " + n + " tries.  This is a timing depenedent test so this is not necessarily an indication of failure.");
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest2() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        int n = 30;
        try {
            int n2;
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page[] pageArray = new Page[n];
            for (n2 = 0; n2 < n; ++n2) {
                pageArray[n2] = this.t_util.t_addPage(containerHandle);
                this.t_util.t_removePage(containerHandle, pageArray[n2]);
            }
            this.t_util.t_dropContainer(transaction, 0L, l);
            this.t_util.t_commit(transaction);
            if (testRollback) {
                l = this.t_util.t_addContainer(transaction, 0L);
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                for (n2 = 0; n2 < n; ++n2) {
                    pageArray[n2] = this.t_util.t_addPage(containerHandle);
                    this.t_util.t_removePage(containerHandle, pageArray[n2]);
                }
                this.t_util.t_abort(transaction);
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("AllocTest2");
    }

    protected void AllocTest3() throws StandardException, T_Fail {
        this.REPORT("allocTest3 cannot be run on an insane server");
    }

    protected void AllocTest4() throws StandardException, T_Fail {
        this.REPORT("allocTest3 cannot be run on an insane server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest5() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            Page page;
            int n;
            long l = this.t_util.t_addContainer(transaction, 0L, 1024, 0, 90, false);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            int n2 = 9;
            T_RawStoreRow[] t_RawStoreRowArray = new T_RawStoreRow[n2];
            for (n = 0; n < n2; ++n) {
                t_RawStoreRowArray[n] = new T_RawStoreRow("row " + n);
            }
            for (n = 0; n < n2; ++n) {
                page = this.t_util.t_addPage(containerHandle);
                this.t_util.t_getPage(containerHandle, 1L).unlatch();
                for (int i = 0; i <= n; ++i) {
                    if (T_Util.t_insert(page, t_RawStoreRowArray[i]) != null) continue;
                    throw T_Fail.testFailMsg("failed to insert " + (i + 1) + " rows into page " + page);
                }
                page.unlatch();
            }
            page = containerHandle.getPageForInsert(0);
            if (page != null) {
                throw T_Fail.testFailMsg("Expect last page to be full");
            }
            for (n = 2; n < 6; ++n) {
                page = containerHandle.getPageForInsert(1);
                if (page == null) {
                    throw T_Fail.testFailMsg("Expect next unfilled page to be " + n);
                }
                if (page.getPageNumber() != (long)n) {
                    throw T_Fail.testFailMsg("Expect next unfilled page to be " + n + ", it is " + page.getPageNumber());
                }
                T_Util.t_insert(page, t_RawStoreRowArray[n]);
                page.unlatch();
                while ((page = containerHandle.getPageForInsert(0)) != null) {
                    if (page.getPageNumber() != (long)n) {
                        throw T_Fail.testFailMsg("Don't expect page number to change from " + n + " to " + page.getPageNumber());
                    }
                    T_Util.t_insert(page, t_RawStoreRowArray[n]);
                    page.unlatch();
                }
            }
            page = containerHandle.getPageForInsert(1);
            if (page != null) {
                throw T_Fail.testFailMsg("don't expect any more pages to be found");
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("AllocTest5 ");
    }

    protected void AllocMTest1(long l) throws StandardException, T_Fail {
        this.REPORT("AllocMTest1 cannot be run on an insane server");
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }

    static {
        commonContainer = -1L;
    }
}

