/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ColumnReference
extends ValueNode {
    public static final int MERGE_UNKNOWN = 0;
    public static final int MERGE_SOURCE = 1;
    public static final int MERGE_TARGET = 2;
    private String _columnName;
    private TableName _qualifiedTableName;
    private int tableNumber;
    private int columnNumber;
    private ResultColumn source;
    private ResultColumn _origSource;
    private String origName;
    private int _origTableNumber = -1;
    private int _origColumnNumber = -1;
    private int tableNumberBeforeFlattening = -1;
    private int columnNumberBeforeFlattening = -1;
    private boolean replacesAggregate;
    private boolean replacesWindowFunctionCall;
    private int nestingLevel = -1;
    private int sourceLevel = -1;
    private boolean scoped;
    private ArrayList<RemapInfo> remaps;
    private int _mergeTableID = 0;

    ColumnReference(String columnName, TableName tableName, int tokBeginOffset, int tokEndOffset, ContextManager cm) {
        super(cm);
        this._columnName = columnName;
        this._qualifiedTableName = tableName;
        this.setBeginOffset(tokBeginOffset);
        this.setEndOffset(tokEndOffset);
        this.tableNumber = -1;
        this.remaps = null;
    }

    ColumnReference(String columnName, TableName tableName, ContextManager cm) {
        super(cm);
        this._columnName = columnName;
        this._qualifiedTableName = tableName;
        this.tableNumber = -1;
        this.remaps = null;
    }

    @Override
    public String toString() {
        return "columnName: " + this._columnName + "\ntableNumber: " + this.tableNumber + "\ncolumnNumber: " + this.columnNumber + "\nreplacesAggregate: " + this.replacesAggregate + "\nreplacesWindowFunctionCall: " + this.replacesWindowFunctionCall + "\ntableName: " + (this._qualifiedTableName != null ? this._qualifiedTableName.toString() : "null") + "\nnestingLevel: " + this.nestingLevel + "\nsourceLevel: " + this.sourceLevel + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.source != null) {
            this.printLabel(depth, "source: ");
            this.source.treePrint(depth + 1);
        }
    }

    boolean getCorrelated() {
        SanityManager.ASSERT(this.nestingLevel != -1, "nestingLevel on " + this._columnName + " is not expected to be -1");
        SanityManager.ASSERT(this.sourceLevel != -1, "sourceLevel on " + this._columnName + " is not expected to be -1");
        return this.sourceLevel != this.nestingLevel;
    }

    void setNestingLevel(int nestingLevel) {
        SanityManager.ASSERT(nestingLevel != -1, "nestingLevel is not expected to be -1");
        this.nestingLevel = nestingLevel;
    }

    private int getNestingLevel() {
        return this.nestingLevel;
    }

    void setSourceLevel(int sourceLevel) {
        SanityManager.ASSERT(sourceLevel != -1, "sourceLevel is not expected to be -1");
        this.sourceLevel = sourceLevel;
    }

    int getSourceLevel() {
        return this.sourceLevel;
    }

    void markGeneratedToReplaceAggregate() {
        this.replacesAggregate = true;
    }

    void markGeneratedToReplaceWindowFunctionCall() {
        this.replacesWindowFunctionCall = true;
    }

    boolean getGeneratedToReplaceAggregate() {
        return this.replacesAggregate;
    }

    boolean getGeneratedToReplaceWindowFunctionCall() {
        return this.replacesWindowFunctionCall;
    }

    @Override
    ValueNode getClone() throws StandardException {
        ColumnReference newCR = new ColumnReference(this._columnName, this._qualifiedTableName, this.getContextManager());
        newCR.copyFields(this);
        return newCR;
    }

    void copyFields(ColumnReference oldCR) throws StandardException {
        super.copyFields(oldCR);
        this.setQualifiedTableName(oldCR.getQualifiedTableName());
        this.tableNumber = oldCR.getTableNumber();
        this.columnNumber = oldCR.getColumnNumber();
        this.source = oldCR.getSource();
        this.nestingLevel = oldCR.getNestingLevel();
        this.sourceLevel = oldCR.getSourceLevel();
        this.replacesAggregate = oldCR.getGeneratedToReplaceAggregate();
        this.replacesWindowFunctionCall = oldCR.getGeneratedToReplaceWindowFunctionCall();
        this.scoped = oldCR.isScoped();
        this.copyTagsFrom(oldCR);
        if (oldCR._mergeTableID != 0) {
            this.setMergeTableID(oldCR.getMergeTableID());
        }
    }

    @Override
    ColumnReference bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        SanityManager.ASSERT(fromList != null, "fromList is expected to be non-null");
        if (fromList.size() == 0) {
            throw StandardException.newException("42X15", this._columnName);
        }
        ResultColumn matchingRC = fromList.bindColumnReference(this);
        if (matchingRC == null) {
            throw StandardException.newException("42X04", this.getSQLColumnName());
        }
        return this;
    }

    String getSQLColumnName() {
        if (this._qualifiedTableName == null) {
            return this._columnName;
        }
        return this._qualifiedTableName.toString() + "." + this._columnName;
    }

    @Override
    public String getColumnName() {
        return this._columnName;
    }

    int getTableNumber() {
        return this.tableNumber;
    }

    void setTableNumber(int tableNumber) {
        SanityManager.ASSERT(tableNumber != -1, "tableNumber not expected to be -1");
        this.tableNumber = tableNumber;
    }

    @Override
    String getTableName() {
        return this._qualifiedTableName != null ? this._qualifiedTableName.getTableName() : null;
    }

    String getSourceTableName() {
        return this.source != null ? this.source.getTableName() : null;
    }

    String getSourceSchemaName() throws StandardException {
        return this.source != null ? this.source.getSchemaName() : null;
    }

    @Override
    public boolean updatableByCursor() {
        return this.source != null ? this.source.updatableByCursor() : false;
    }

    public TableName getQualifiedTableName() {
        return this._qualifiedTableName;
    }

    void setQualifiedTableName(TableName tableName) {
        this._qualifiedTableName = tableName;
    }

    int getColumnNumber() {
        return this.columnNumber;
    }

    void setColumnNumber(int colNum) {
        this.columnNumber = colNum;
    }

    ResultColumn getSource() {
        return this.source;
    }

    void setSource(ResultColumn source) {
        this.source = source;
    }

    @Override
    ValueNode putAndsOnTop() throws StandardException {
        BooleanConstantNode trueNode = new BooleanConstantNode(true, this.getContextManager());
        BinaryRelationalOperatorNode equalsNode = new BinaryRelationalOperatorNode(0, (ValueNode)this, trueNode, false, this.getContextManager());
        equalsNode.bindComparisonOperator();
        AndNode andNode = new AndNode(equalsNode, trueNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) {
        SanityManager.ASSERT(this.tableNumber >= 0, "tableNumber is expected to be non-negative");
        referencedTabs.set(this.tableNumber);
        return !this.replacesAggregate && !this.replacesWindowFunctionCall && (this.source.getExpression() instanceof ColumnReference || this.source.getExpression() instanceof VirtualColumnNode || this.source.getExpression() instanceof ConstantNode);
    }

    void remapColumnReferences() {
        ValueNode expression = this.source.getExpression();
        if (!(expression instanceof VirtualColumnNode) && !(expression instanceof ColumnReference)) {
            return;
        }
        if (this.scoped && this._origSource != null) {
            if (this.remaps == null) {
                this.remaps = new ArrayList();
            }
            this.remaps.add(new RemapInfo(this.columnNumber, this.tableNumber, this._columnName, this.source));
        } else {
            this._origSource = this.source;
            this.origName = this._columnName;
            this._origColumnNumber = this.columnNumber;
            this._origTableNumber = this.tableNumber;
        }
        this.source = this.getSourceResultColumn();
        this._columnName = this.source.getName();
        int n = this.columnNumber = this.source.getExpression() instanceof VirtualColumnNode ? this.source.getVirtualColumnId() : this.source.getColumnPosition();
        if (this.source.getExpression() instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.source.getExpression();
            this.tableNumber = cr.getTableNumber();
            if (this.tableNumber == -1 && !cr.getGeneratedToReplaceAggregate()) {
                SanityManager.THROWASSERT("tableNumber not expected to be -1, origName = " + this.origName);
            }
        }
    }

    void unRemapColumnReferences() {
        if (this._origSource == null) {
            return;
        }
        if (this.remaps == null || this.remaps.isEmpty()) {
            this.source = this._origSource;
            this._origSource = null;
            this._columnName = this.origName;
            this.origName = null;
            this.tableNumber = this._origTableNumber;
            this.columnNumber = this._origColumnNumber;
        } else {
            RemapInfo rI = this.remaps.remove(this.remaps.size() - 1);
            this.source = rI.getSource();
            this._columnName = rI.getColumnName();
            this.tableNumber = rI.getTableNumber();
            this.columnNumber = rI.getColumnNumber();
            if (this.remaps.isEmpty()) {
                this.remaps = null;
            }
        }
    }

    protected boolean hasBeenRemapped() {
        return this._origSource != null;
    }

    @Override
    ResultColumn getSourceResultColumn() {
        return this.source.getExpression().getSourceResultColumn();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        ResultColumn sourceRC = this.source;
        if (!this.source.isRedundant()) {
            return this;
        }
        ResultColumn rc = this.source;
        while (rc != null && rc.isRedundant()) {
            ResultColumn nextRC = rc.getExpression().getSourceResultColumn();
            if (nextRC != null && nextRC.isRedundant()) {
                sourceRC = nextRC;
            }
            rc = nextRC;
        }
        if (sourceRC == null) {
            SanityManager.THROWASSERT("sourceRC is expected to be non-null for " + this._columnName);
        }
        if (!sourceRC.isRedundant()) {
            SanityManager.THROWASSERT("sourceRC is expected to be redundant for " + this._columnName);
        }
        if (sourceRC.getExpression() instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)sourceRC.getExpression();
            ResultSetNode rsn = vcn.getSourceResultSet();
            if (rsn instanceof FromTable) {
                ResultColumn ftRC;
                FromTable ft = (FromTable)rsn;
                ResultColumnList rcl = ft.getResultColumns();
                if (this.tableNumberBeforeFlattening == -1) {
                    this.tableNumberBeforeFlattening = this.tableNumber;
                    this.columnNumberBeforeFlattening = this.columnNumber;
                }
                if ((ftRC = rcl.getResultColumn(this.tableNumberBeforeFlattening, this.columnNumberBeforeFlattening, this._columnName)) == null) {
                    ftRC = rcl.getResultColumn(this._columnName);
                }
                SanityManager.ASSERT(ftRC != null, "Failed to find column '" + this._columnName + "' in the RCL for '" + String.valueOf(ft.getTableName()) + "'.");
                this.tableNumber = ft.getTableNumber();
                SanityManager.ASSERT(this.tableNumber != -1, "tableNumber not expected to be -1");
                this.columnNumber = ftRC.getExpression() instanceof VirtualColumnNode ? ftRC.getVirtualColumnId() : ftRC.getColumnPosition();
            } else {
                SanityManager.THROWASSERT("rsn expected to be a FromTable, but is a " + rsn.getClass().getName());
            }
            this.source = sourceRC.getExpression().getSourceResultColumn();
            return this;
        }
        return sourceRC.getExpression().getClone();
    }

    void getTablesReferenced(JBitSet refs) {
        if (refs.size() < this.tableNumber) {
            refs.grow(this.tableNumber);
        }
        if (this.tableNumber != -1) {
            refs.set(this.tableNumber);
        }
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return whereClause.constantColumn(this);
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int sourceResultSetNumber = this.source.getResultSetNumber();
        if (this.source.isRedundant()) {
            this.source.generateExpression(acb, mb);
            return;
        }
        if (sourceResultSetNumber < 0) {
            SanityManager.THROWASSERT("sourceResultSetNumber expected to be >= 0 for " + this.getTableName() + "." + this.getColumnName());
        }
        acb.pushColumnReference(mb, sourceResultSetNumber, this.source.getVirtualColumnId());
        mb.cast(this.getTypeCompiler().interfaceName());
    }

    @Override
    String getSchemaName() {
        return this._qualifiedTableName != null ? this._qualifiedTableName.getSchemaName() : null;
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    boolean pointsToColumnReference() {
        return this.source.getExpression() instanceof ColumnReference;
    }

    @Override
    DataTypeDescriptor getTypeServices() {
        if (this.source == null) {
            return super.getTypeServices();
        }
        return this.source.getTypeServices();
    }

    protected ResultSetNode getSourceResultSet(int[] colNum) throws StandardException {
        if (this.source == null) {
            return null;
        }
        ResultColumn rc = this.getSource();
        ValueNode rcExpr = rc.getExpression();
        colNum[0] = this.getColumnNumber();
        while (rcExpr != null && (rc.isRedundant() || rcExpr instanceof ColumnReference)) {
            if (rcExpr instanceof ColumnReference) {
                colNum[0] = ((ColumnReference)rcExpr).getColumnNumber();
                rc = ((ColumnReference)rcExpr).getSource();
            }
            while (rc.isRedundant()) {
                rcExpr = rc.getExpression();
                if (rcExpr instanceof VirtualColumnNode) {
                    rc = rcExpr.getSourceResultColumn();
                    continue;
                }
                if (!(rcExpr instanceof ColumnReference)) break;
                colNum[0] = ((ColumnReference)rcExpr).getColumnNumber();
                rc = ((ColumnReference)rcExpr).getSource();
            }
            rcExpr = rc.getExpression();
        }
        if (rcExpr != null && rcExpr instanceof VirtualColumnNode) {
            return ((VirtualColumnNode)rcExpr).getSourceResultSet();
        }
        colNum[0] = -1;
        return null;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeKind(o)) {
            return false;
        }
        ColumnReference other = (ColumnReference)o;
        return this.tableNumber == other.tableNumber && this._columnName.equals(other.getColumnName());
    }

    protected void markAsScoped() {
        this.scoped = true;
    }

    protected boolean isScoped() {
        return this.scoped;
    }

    void setMergeTableID(int mergeTableID) {
        if (this._mergeTableID != 0 && this._mergeTableID != mergeTableID) {
            SanityManager.ASSERT(this._mergeTableID == mergeTableID, "MERGE statement can't re-associate column " + this.getSQLColumnName() + " from " + this.prettyPrintMergeTableID(this._mergeTableID) + " to " + this.prettyPrintMergeTableID(mergeTableID));
        }
        this._mergeTableID = mergeTableID;
    }

    private String prettyPrintMergeTableID(int mergeTableID) {
        switch (mergeTableID) {
            case 1: {
                return "SOURCE";
            }
            case 2: {
                return "TARGET";
            }
        }
        return "UNKNOWN";
    }

    int getMergeTableID() {
        return this._mergeTableID;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this._qualifiedTableName != null) {
            this.setQualifiedTableName((TableName)this._qualifiedTableName.accept(v));
        }
    }

    private static class RemapInfo {
        int colNum;
        int tableNum;
        String colName;
        ResultColumn source;

        RemapInfo(int cNum, int tNum, String cName, ResultColumn rc) {
            this.colNum = cNum;
            this.tableNum = tNum;
            this.colName = cName;
            this.source = rc;
        }

        int getColumnNumber() {
            return this.colNum;
        }

        int getTableNumber() {
            return this.tableNum;
        }

        String getColumnName() {
            return this.colName;
        }

        ResultColumn getSource() {
            return this.source;
        }

        void setColNumber(int cNum) {
            this.colNum = cNum;
        }

        void setTableNumber(int tNum) {
            this.tableNum = tNum;
        }

        void setColName(String cName) {
            this.colName = cName;
        }

        void setSource(ResultColumn rc) {
            this.source = rc;
        }
    }
}

