/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConstantExpressionTest
extends BaseJDBCTestCase {
    public ConstantExpressionTest(String name) throws SQLException {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ConstantExpressionTest.class);
    }

    public void setUp() throws SQLException {
        String sql = "create table t1(c1 int)";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        sql = "insert into t1 values 1, 2, 3";
        ConstantExpressionTest.assertEquals((String)"Fail to insert into table", (int)3, (int)st.executeUpdate(sql));
        st.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.dropTable("t1");
        super.tearDown();
    }

    public void testFalseConstantExpressions() throws SQLException {
        ResultSet rs;
        Object sql;
        String[] falseCases = new String[]{"1 <> 1", "1 = 1 and 1 = 0", "1 = (2 + 3 - 2)", "(case when 1 = 1 then 0 else 1 end) = 1", "1 in (2, 3, 4)", "1 between 2 and 3"};
        Statement st = this.createStatement(1004, 1007);
        for (int i = 0; i < falseCases.length; ++i) {
            sql = "select * from t1 where " + falseCases[i];
            rs = st.executeQuery((String)sql);
            JDBC.assertEmpty(rs);
        }
        st.close();
        sql = "select * from t1 where ? = 1";
        PreparedStatement ps1 = this.prepareStatement((String)sql);
        ps1.setInt(1, 0);
        rs = ps1.executeQuery();
        JDBC.assertEmpty(rs);
        ps1.close();
        sql = "select * from t1 where cast(? as int) = 1";
        PreparedStatement ps2 = this.prepareStatement((String)sql);
        ps2.setInt(1, 0);
        rs = ps2.executeQuery();
        JDBC.assertEmpty(rs);
        ps2.close();
    }

    public void testTrueConstantExpressions() throws SQLException {
        ResultSet rs;
        Object sql;
        String[] trueCases = new String[]{"1 = 1", "1 = 0 or 1 = 1", "1 + 2 = (2 + 3 - 2)", "(case when 1 = 1 then 1 else 0 end) = 1", "1 in (2, 3, 4, 4, 3, 2, 1)", "1 + 1 between 0 and 3"};
        String[][] content = new String[][]{{"1"}, {"2"}, {"3"}};
        Statement st = this.createStatement(1004, 1007);
        for (int i = 0; i < trueCases.length; ++i) {
            sql = "select * from t1 where " + trueCases[i];
            rs = st.executeQuery((String)sql);
            JDBC.assertFullResultSet(rs, content);
        }
        st.close();
        sql = "select * from t1 where ? = 1";
        PreparedStatement ps1 = this.prepareStatement((String)sql);
        ps1.setInt(1, 1);
        rs = ps1.executeQuery();
        JDBC.assertFullResultSet(rs, content);
        ps1.close();
        sql = "select * from t1 where cast(? as int) = 1";
        PreparedStatement ps2 = this.prepareStatement((String)sql);
        ps2.setInt(1, 1);
        rs = ps2.executeQuery();
        JDBC.assertFullResultSet(rs, content);
        ps2.close();
    }
}

