/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.Connection;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.tools.dblook;
import org.apache.derbyTesting.functionTests.tests.tools.dblook_test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Test_6661
extends BaseJDBCTestCase {
    private static final String[][] EXPECTED_CONSTRAINT_STATE = new String[][]{{"CHECK6661_INIT_DEFERRED", "e"}, {"CHECK6661_INIT_IMMEDIATE", "i"}, {"CHECK6661_VANILLA", "E"}, {"TPRIM6661_INIT_DEFERRED", "e"}, {"TPRIM6661_INIT_IMMEDIATE", "i"}, {"TPRIM6661_VANILLA", "E"}, {"TREF6661_INIT_DEFERRED", "e"}, {"TREF6661_INIT_IMMEDIATE", "i"}, {"TREF6661_VANILLA", "E"}, {"TUNIQUE6661_INIT_DEFERRED", "e"}, {"TUNIQUE6661_INIT_IMMEDIATE", "i"}, {"TUNIQUE6661_VANILLA", "E"}};
    private static final String DBLOOK_OUTPUT = SupportFilesSetup.getReadWrite("dblookOutput.sql").getPath();

    public Test_6661(String name) {
        super(name);
    }

    public static Test suite() {
        SupportFilesSetup supportFileWrapper;
        BaseTestSuite baseTest = new BaseTestSuite(Test_6661.class, "Test_6661");
        TestSetup singleUseWrapper = TestConfiguration.singleUseDatabaseDecorator((Test)baseTest);
        CleanDatabaseTestSetup cleanDatabaseWrapper = new CleanDatabaseTestSetup((Test)singleUseWrapper);
        SupportFilesSetup noSecurityWrapper = supportFileWrapper = new SupportFilesSetup((Test)cleanDatabaseWrapper);
        return noSecurityWrapper;
    }

    public void test_01() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table tprim6661_vanilla\n(\n    keyCol  int not null,\n    constraint tprim6661_vanilla primary key( keyCol )\n)\n");
        this.goodStatement(conn, "create table tprim6661_init_deferred\n(\n    keyCol  int not null,\n    constraint tprim6661_init_deferred primary key( keyCol ) deferrable initially deferred\n)\n");
        this.goodStatement(conn, "create table tprim6661_init_immediate\n(\n    keyCol  int not null,\n    constraint tprim6661_init_immediate primary key( keyCol ) deferrable\n)\n");
        this.goodStatement(conn, "create table tunique6661_vanilla\n(\n    keyCol  int not null,\n    constraint tunique6661_vanilla primary key( keyCol )\n)\n");
        this.goodStatement(conn, "create table tunique6661_init_deferred\n(\n    keyCol  int not null,\n    constraint tunique6661_init_deferred primary key( keyCol ) deferrable initially deferred\n)\n");
        this.goodStatement(conn, "create table tunique6661_init_immediate\n(\n    keyCol  int not null,\n    constraint tunique6661_init_immediate primary key( keyCol ) deferrable\n)\n");
        this.goodStatement(conn, "create table tref6661\n(\n    tref6661_vanilla int,\n    tref6661_init_deferred int,\n    tref6661_init_immediate int,\n\n    constraint tref6661_vanilla foreign key( tref6661_vanilla ) references tprim6661_vanilla( keyCol ),\n    constraint tref6661_init_deferred foreign key( tref6661_init_deferred ) references tprim6661_vanilla( keyCol ) deferrable initially deferred,\n    constraint tref6661_init_immediate foreign key( tref6661_init_immediate ) references tprim6661_vanilla( keyCol ) deferrable\n)\n");
        this.goodStatement(conn, "create table tcheck6661\n(\n    a int,\n\n    constraint check6661_vanilla check( a > 0 ),\n    constraint check6661_init_deferred check( a > 10 ) deferrable initially deferred,\n    constraint check6661_init_immediate check( a > 100 ) deferrable\n)\n");
        String query = "select constraintname, state from sys.sysconstraints order by constraintname";
        this.assertResults(conn, query, EXPECTED_CONSTRAINT_STATE, true);
        TestConfiguration config = this.getTestConfiguration();
        String dbName = config.getPhysicalDatabaseName(config.getDefaultDatabaseName());
        new dblook(new String[]{"-d", "jdbc:derby:" + dbName, "-o", DBLOOK_OUTPUT});
        this.goodStatement(conn, "drop table tcheck6661");
        this.goodStatement(conn, "drop table tref6661");
        this.goodStatement(conn, "drop table tunique6661_init_immediate");
        this.goodStatement(conn, "drop table tunique6661_init_deferred");
        this.goodStatement(conn, "drop table tunique6661_vanilla");
        this.goodStatement(conn, "drop table tprim6661_init_immediate");
        this.goodStatement(conn, "drop table tprim6661_init_deferred");
        this.goodStatement(conn, "drop table tprim6661_vanilla");
        this.assertResults(conn, query, new String[0][], true);
        dblook_test.runDDL(conn, DBLOOK_OUTPUT);
        this.assertResults(conn, query, EXPECTED_CONSTRAINT_STATE, true);
    }
}

