/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public class T_UUIDFactory
extends T_Generic {
    protected UUIDFactory factory;
    boolean resultSoFar;

    @Override
    protected String getModuleToTestProtocolName() {
        return "A.Dummy.Name";
    }

    @Override
    protected void runTests() throws T_Fail {
        this.factory = T_UUIDFactory.getMonitor().getUUIDFactory();
        if (this.factory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " module not started.");
        }
        if (!this.testUUID()) {
            throw T_Fail.testFailMsg("testUUID indicated failure");
        }
    }

    protected boolean testUUID() {
        String suuid1;
        UUID uuid3;
        String message;
        UUID uuid2;
        this.resultSoFar = true;
        UUID uuid1 = this.factory.createUUID();
        if (uuid1.equals((Object)(uuid2 = this.factory.createUUID()))) {
            message = "UUID factory created matching UUIDS '%0' and '%1'";
            this.out.printlnWithHeader(message);
            this.resultSoFar = false;
        }
        if (!uuid1.equals((Object)uuid1)) {
            message = "UUID '%0' does not equal itself";
            this.resultSoFar = false;
        }
        if (uuid1.hashCode() != uuid1.hashCode()) {
            message = "UUID '%0' does not hash to the same thing twice.";
            this.out.printlnWithHeader(message);
            this.resultSoFar = false;
        }
        if (!(uuid3 = this.factory.recreateUUID(suuid1 = uuid1.toString())).equals((Object)uuid1)) {
            String message2 = "Couldn't recreate UUID: " + uuid3.toString() + " != " + uuid1.toString();
            this.out.printlnWithHeader(message2);
            this.resultSoFar = false;
        }
        this.testUUIDConversions(this.out, "7878FCD0-DA09-11d0-BAFE-0060973F0942");
        this.testUUIDConversions(this.out, "80706050-4030-2010-8070-605040302010");
        this.testUUIDConversions(this.out, "f0e0d0c0-b0a0-9080-7060-504030201000");
        this.testUUIDConversions(this.out, "00000000-0000-0000-0000-000000000000");
        this.testUUIDConversions(this.out, "ffffffff-ffff-ffff-ffff-ffffffffffff");
        this.testUUIDConversions(this.out, this.factory.createUUID().toString());
        this.testUUIDConversions(this.out, this.factory.createUUID().toString());
        return this.resultSoFar;
    }

    private void testUUIDConversions(HeaderPrintWriter out, String uuidstring) {
        UUID uuid = this.factory.recreateUUID(uuidstring);
        if (!uuidstring.equalsIgnoreCase(uuid.toString())) {
            String message = "Couldn't recreate UUID String: " + uuidstring + " != " + uuid.toString();
            out.printlnWithHeader(message);
            this.resultSoFar = false;
        }
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }
}

