/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class InsertOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected byte insertFlag;
    protected transient int startColumn;
    protected transient ByteArray preparedLog;

    InsertOperation(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int startColumn, boolean isLongColumn, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, int overflowThreshold) throws StandardException {
        super(page, undo, recordId);
        this.doMeSlot = slot;
        this.insertFlag = insertFlag;
        this.startColumn = startColumn;
        try {
            this.writeOptionalDataToBuffer(t, logBuffer, row, validColumns, isLongColumn, realStartColumn, realSpaceOnPage, overflowThreshold);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe, new Object[0]);
        }
    }

    public InsertOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        out.writeByte(this.insertFlag);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.insertFlag = in.readByte();
    }

    @Override
    public int getTypeFormatId() {
        return 103;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.page.storeRecord(instant, this.doMeSlot, true, in);
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, int undoRecordId, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(undoRecordId, 0);
        if (undoRecordId != this.recordId && undoPage.getPageNumber() == this.getPageId().getPageNumber()) {
            SanityManager.THROWASSERT("recordId changed from " + this.recordId + " to " + undoRecordId + " but page number did not change " + undoPage.getPageNumber());
        }
        if (slot == -1) {
            SanityManager.THROWASSERT("recordId " + undoRecordId + " not found on page " + undoPage.getPageNumber());
        }
        RawTransaction rxact = (RawTransaction)xact;
        if ((this.insertFlag & 2) != 0) {
            undoPage.purgeRecord(CLRInstant, slot, undoRecordId);
            if (rxact.handlesPostTerminationWork() && undoPage.isOverflowPage() && undoPage.recordCount() == 0) {
                ReclaimSpace work = new ReclaimSpace(2, (PageKey)undoPage.getIdentity(), rxact.getDataFactory(), true);
                rxact.addPostTerminationWork(work);
            }
        } else {
            undoPage.setDeleteStatus(CLRInstant, slot, true);
            if (rxact.handlesPostTerminationWork() && !undoPage.isOverflowPage() && undoPage.shouldReclaimSpace(undoPage.getPageNumber() == 1L ? 1 : 0, slot)) {
                ((BaseDataFileFactory)rxact.getDataFactory()).insertUndoNotify(rxact, undoPage.getPageKey());
            }
        }
        undoPage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreLoggedRow(Object[] row, LimitObjectInput in) throws StandardException, IOException {
        Page p = null;
        try {
            p = this.getContainer().getPage(this.getPageId().getPageNumber());
            ((BasePage)p).restoreRecordFromStream(in, row);
        }
        finally {
            if (p != null) {
                p.unlatch();
                p = null;
            }
        }
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        if (!this.getPageId().equals(undoPage.getPageId())) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different page. doMe page:" + String.valueOf(this.getPageId()) + " undoPage:" + String.valueOf(undoPage.getPageId()));
        }
        if (slot != this.doMeSlot) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different slot. doMe slot:" + this.doMeSlot + " undoMe slot: " + slot + " recordId:" + this.recordId);
        }
        this.insertFlag = (byte)(this.insertFlag | 2);
        this.undoMe(xact, undoPage, this.recordId, CLRinstant, in);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    public int getNextStartColumn() {
        return this.startColumn;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, DynamicByteArrayOutputStream logBuffer, Object[] row, FormatableBitSet validColumns, boolean isLongColumn, int realStartColumn, int realSpaceOnPage, int overflowThreshold) throws StandardException, IOException {
        SanityManager.ASSERT(this.page != null);
        DynamicByteArrayOutputStream localLogBuffer = null;
        if (logBuffer != null) {
            localLogBuffer = logBuffer;
        } else {
            realStartColumn = -1;
            realSpaceOnPage = -1;
            localLogBuffer = t.getLogBuffer();
        }
        this.startColumn = isLongColumn ? this.page.logLongColumn(this.doMeSlot, this.recordId, row[0], localLogBuffer) : this.page.logRow(this.doMeSlot, true, this.recordId, row, validColumns, localLogBuffer, this.startColumn, this.insertFlag, realStartColumn, realSpaceOnPage, overflowThreshold);
        int optionalDataStart = localLogBuffer.getBeginPosition();
        int optionalDataLength = localLogBuffer.getPosition() - optionalDataStart;
        this.preparedLog = new ByteArray(localLogBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    @Override
    public String toString() {
        return super.toString() + "Insert :  Slot=" + this.doMeSlot + " recordId=" + this.recordId;
    }
}

