/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derbyTesting.system.nstest.NsTest;

public class SequenceReader
extends Thread {
    private Connection conn;
    private int delay = 60000;
    public boolean stopNow = false;

    public SequenceReader(Connection connection, int n) {
        this.conn = connection;
        this.delay = n;
    }

    @Override
    public void run() {
        NsTest.logger.println("Starting the sequence reader thread with delay = " + this.delay);
        while (!this.stopNow) {
            try {
                this.readSequenceValue();
                SequenceReader.sleep(this.delay);
                if (NsTest.numActiveTestThreads() != 0 && NsTest.numActiveTestThreads() > 1) continue;
                NsTest.logger.println("no more test threads, finishing SequenceReader thread also");
                this.readSequenceValue();
                this.stopNow = true;
            }
            catch (InterruptedException interruptedException) {
                NsTest.logger.println("SequenceReader: unexpected error in sleep");
            }
        }
    }

    private void readSequenceValue() {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("values syscs_util.syscs_peek_at_sequence( 'NSTEST', 'NSTESTTAB_SEQ' )");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            NsTest.logger.println("Next sequence number = " + l);
            NsTest.updateSequenceTracker(l);
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            NsTest.printException(SequenceReader.class.getName(), exception);
        }
    }
}

