/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Controls;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryMovedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.CopyEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.DeleteEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.RenameEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveEntriesRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private IEntry[] oldEntries;
    private IEntry newParent;
    private IEntry[] newEntries;
    private Set<ISearch> searchesToUpdateSet = new HashSet<ISearch>();
    private SimulateRenameDialog dialog;

    public MoveEntriesRunnable(IEntry[] entries, IEntry newParent, SimulateRenameDialog dialog) {
        this.browserConnection = newParent.getBrowserConnection();
        this.oldEntries = entries;
        this.newParent = newParent;
        this.dialog = dialog;
        this.newEntries = new IEntry[this.oldEntries.length];
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_name_1 : BrowserCoreMessages.jobs__move_entry_name_n;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.add(this.newParent);
        l.addAll(Arrays.asList(this.oldEntries));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_error_1 : BrowserCoreMessages.jobs__move_entry_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)(this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_task_1 : BrowserCoreMessages.jobs__move_entry_task_n), (Object[])new String[0]), 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        int numAdd = 0;
        int numDel = 0;
        boolean isSimulatedRename = false;
        Dn parentDn = this.newParent.getDn();
        int i = 0;
        while (i < this.oldEntries.length) {
            dummyMonitor.reset();
            IEntry oldEntry = this.oldEntries[i];
            Dn oldDn = oldEntry.getDn();
            Dn newDn = null;
            try {
                newDn = parentDn.add(oldDn.getRdn());
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                newDn = Dn.EMPTY_DN;
            }
            RenameEntryRunnable.renameEntry(this.browserConnection, oldEntry, newDn, dummyMonitor);
            if (dummyMonitor.errorsReported()) {
                if (this.dialog != null && StudioLdapException.isContextNotEmptyException((Exception)dummyMonitor.getException())) {
                    if (numAdd == 0) {
                        this.dialog.setEntryInfo(this.browserConnection, oldDn, newDn);
                        this.dialog.open();
                        isSimulatedRename = this.dialog.isSimulateRename();
                    }
                    if (isSimulatedRename) {
                        dummyMonitor.reset();
                        numAdd = CopyEntriesRunnable.copyEntry(oldEntry, this.newParent, null, 2, numAdd, null, dummyMonitor, monitor);
                        if (!dummyMonitor.errorsReported()) {
                            dummyMonitor.reset();
                            numDel = DeleteEntriesRunnable.optimisticDeleteEntryRecursive(this.browserConnection, oldDn, oldEntry.isReferral(), false, numDel, dummyMonitor, monitor);
                        }
                    } else {
                        Exception exception = dummyMonitor.getException();
                        monitor.reportError(exception);
                    }
                } else {
                    Exception exception = dummyMonitor.getException();
                    monitor.reportError(exception);
                }
            }
            if (!dummyMonitor.errorsReported()) {
                IEntry newEntry;
                this.browserConnection.uncacheEntryRecursive(oldEntry);
                oldEntry.getParententry().deleteChild(oldEntry);
                boolean hasMoreChildren = this.newParent.hasMoreChildren() || !this.newParent.isChildrenInitialized();
                ArrayList<Control> controls = new ArrayList<Control>();
                if (oldEntry.isReferral()) {
                    controls.add((Control)Controls.MANAGEDSAIT_CONTROL);
                }
                this.newEntries[i] = newEntry = ReadEntryRunnable.getEntry(this.browserConnection, newDn, controls, monitor);
                this.newParent.addChild(newEntry);
                this.newParent.setHasMoreChildren(hasMoreChildren);
                List<ISearch> searches = this.browserConnection.getSearchManager().getSearches();
                block3: for (ISearch search : searches) {
                    ISearchResult[] searchResults;
                    if (search.getSearchResults() == null) continue;
                    ISearchResult[] iSearchResultArray = searchResults = search.getSearchResults();
                    int n = searchResults.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISearchResult result = iSearchResultArray[n2];
                        if (oldEntry.equals(result.getEntry())) {
                            search.setSearchResults(null);
                            this.searchesToUpdateSet.add(search);
                            continue block3;
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        if (this.newEntries.length < 2) {
            int i = 0;
            while (i < this.newEntries.length) {
                if (this.oldEntries[i] != null && this.newEntries[i] != null) {
                    EventRegistry.fireEntryUpdated(new EntryMovedEvent(this.oldEntries[i], this.newEntries[i]), this);
                }
                ++i;
            }
        } else {
            IEntry[] iEntryArray = this.oldEntries;
            int n = this.oldEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IEntry oldEntry = iEntryArray[n2];
                oldEntry.getParententry().setChildrenInitialized(false);
                ++n2;
            }
            this.newParent.setChildrenInitialized(false);
            EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), this);
        }
    }
}

