/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapFilter {
    private LdapFilterToken startToken = null;
    private LdapFilterComponent filterComponent = null;
    private LdapFilterToken stopToken = null;
    private List<LdapFilterToken> otherTokens = new ArrayList<LdapFilterToken>(2);

    public boolean setStartToken(LdapFilterToken startToken) {
        if (this.startToken == null && startToken != null && startToken.getType() == 11) {
            this.startToken = startToken;
            return true;
        }
        return false;
    }

    public boolean setFilterComponent(LdapFilterComponent filterComponent) {
        if (this.startToken != null && this.filterComponent == null && filterComponent != null) {
            this.filterComponent = filterComponent;
            return true;
        }
        return false;
    }

    public boolean setStopToken(LdapFilterToken stopToken) {
        if (this.startToken != null && this.stopToken == null && stopToken != null && stopToken.getType() == 12) {
            this.stopToken = stopToken;
            return true;
        }
        return false;
    }

    public void addOtherToken(LdapFilterToken otherToken) {
        this.otherTokens.add(otherToken);
    }

    public LdapFilterToken getStartToken() {
        return this.startToken;
    }

    public LdapFilterComponent getFilterComponent() {
        return this.filterComponent;
    }

    public LdapFilterToken getStopToken() {
        return this.stopToken;
    }

    public LdapFilterToken[] getTokens() {
        ArrayList<LdapFilterToken> tokenList = new ArrayList<LdapFilterToken>();
        if (this.startToken != null) {
            tokenList.add(this.startToken);
        }
        if (this.stopToken != null) {
            tokenList.add(this.stopToken);
        }
        if (this.filterComponent != null) {
            tokenList.addAll(Arrays.asList(this.filterComponent.getTokens()));
        }
        tokenList.addAll(this.otherTokens);
        Object[] tokens = tokenList.toArray(new LdapFilterToken[tokenList.size()]);
        Arrays.sort(tokens);
        return tokens;
    }

    public boolean isValid() {
        return this.startToken != null && this.filterComponent != null && this.filterComponent.isValid() && this.stopToken != null && this.otherTokens.isEmpty();
    }

    public LdapFilter[] getInvalidFilters() {
        if (this.startToken == null || this.filterComponent == null || this.stopToken == null) {
            return new LdapFilter[]{this};
        }
        return this.filterComponent.getInvalidFilters();
    }

    public LdapFilter getFilter(int offset) {
        if (this.startToken != null && this.startToken.getOffset() == offset) {
            return this;
        }
        if (this.stopToken != null && this.stopToken.getOffset() == offset) {
            return this;
        }
        if (this.otherTokens != null && this.otherTokens.size() > 0) {
            int i = 0;
            while (i < this.otherTokens.size()) {
                LdapFilterToken otherToken = this.otherTokens.get(i);
                if (otherToken != null && otherToken.getOffset() <= offset && offset < otherToken.getOffset() + otherToken.getLength()) {
                    return this;
                }
                ++i;
            }
        }
        if (this.filterComponent != null) {
            return this.filterComponent.getFilter(offset);
        }
        return this;
    }

    public String getInvalidCause() {
        if (this.stopToken == null) {
            return BrowserCoreMessages.model_filter_missing_closing_parenthesis;
        }
        if (this.filterComponent == null) {
            return BrowserCoreMessages.model_filter_missing_filter_expression;
        }
        return this.filterComponent.getInvalidCause();
    }

    public String toString() {
        LdapFilterToken[] tokens;
        StringBuffer sb = new StringBuffer();
        LdapFilterToken[] ldapFilterTokenArray = tokens = this.getTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            LdapFilterToken token = ldapFilterTokenArray[n2];
            if (token.getType() != 0 && token.getType() != 1 && token.getType() != -2 && token.getType() != -1) {
                sb.append(token.getValue());
            }
            ++n2;
        }
        return sb.toString();
    }

    public String toUserProvidedString() {
        LdapFilterToken[] tokens;
        StringBuffer sb = new StringBuffer();
        LdapFilterToken[] ldapFilterTokenArray = tokens = this.getTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            LdapFilterToken token = ldapFilterTokenArray[n2];
            sb.append(token.getValue());
            ++n2;
        }
        return sb.toString();
    }
}

