/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.dialogs;

import java.util.Collection;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.ItemPermission;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.Messages;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemGrantsAndDenialsComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemUserClassesComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ItemPermissionDialog
extends Dialog {
    private ACIItemValueWithContext context;
    private ItemPermission initialItemPermission;
    private ItemPermission returnItemPermission;
    private Button precedenceCheckbox = null;
    private Spinner precedenceSpinner = null;
    private ACIItemUserClassesComposite userClassesComposite;
    private ACIItemGrantsAndDenialsComposite grantsAndDenialsComposite;

    public ItemPermissionDialog(Shell parentShell, ItemPermission initialItemPermission, ACIItemValueWithContext context) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.context = context;
        this.initialItemPermission = initialItemPermission;
        this.returnItemPermission = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ItemPermissionDialog.dialog.text"));
        shell.setImage(Activator.getDefault().getImage(Messages.getString("ItemPermissionDialog.dialog.icon")));
    }

    protected void okPressed() {
        try {
            int precedence = this.precedenceCheckbox.getSelection() ? this.precedenceSpinner.getSelection() : -1;
            Collection<UserClass> userClasses = this.userClassesComposite.getUserClasses();
            Collection<GrantAndDenial> grantsAndDenials = this.grantsAndDenialsComposite.getGrantsAndDenials();
            this.returnItemPermission = new ItemPermission(Integer.valueOf(precedence), grantsAndDenials, userClasses);
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ItemPermissionDialog.error.invalidItemPermission"), (String)e.getMessage());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertVerticalDLUsToPixels(300) * 4 / 3;
        composite.setLayoutData((Object)gd);
        Composite spinnerComposite = new Composite(composite, 0);
        spinnerComposite.setLayout((Layout)new GridLayout(2, false));
        spinnerComposite.setLayoutData((Object)new GridData());
        this.precedenceCheckbox = new Button(spinnerComposite, 32);
        this.precedenceCheckbox.setText(Messages.getString("ItemPermissionDialog.precedence.label"));
        this.precedenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPermissionDialog.this.precedenceSpinner.setEnabled(ItemPermissionDialog.this.precedenceCheckbox.getSelection());
            }
        });
        this.precedenceSpinner = new Spinner(spinnerComposite, 2048);
        this.precedenceSpinner.setMinimum(0);
        this.precedenceSpinner.setMaximum(255);
        this.precedenceSpinner.setDigits(0);
        this.precedenceSpinner.setIncrement(1);
        this.precedenceSpinner.setPageIncrement(10);
        this.precedenceSpinner.setSelection(0);
        this.precedenceSpinner.setEnabled(false);
        GridData precedenceGridData = new GridData();
        precedenceGridData.grabExcessHorizontalSpace = true;
        precedenceGridData.verticalAlignment = 2;
        precedenceGridData.horizontalAlignment = 1;
        precedenceGridData.widthHint = 36;
        this.precedenceSpinner.setLayoutData((Object)precedenceGridData);
        this.userClassesComposite = new ACIItemUserClassesComposite(composite, 0);
        this.userClassesComposite.setContext(this.context);
        this.grantsAndDenialsComposite = new ACIItemGrantsAndDenialsComposite(composite, 0);
        if (this.initialItemPermission != null) {
            if (this.initialItemPermission.getPrecedence() != null && this.initialItemPermission.getPrecedence() > -1) {
                this.precedenceCheckbox.setSelection(true);
                this.precedenceSpinner.setEnabled(true);
                this.precedenceSpinner.setSelection(this.initialItemPermission.getPrecedence().intValue());
            }
            this.userClassesComposite.setUserClasses(this.initialItemPermission.getUserClasses());
            this.grantsAndDenialsComposite.setGrantsAndDenials(this.initialItemPermission.getGrantsAndDenials());
        }
        ItemPermissionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public ItemPermission getItemPermission() {
        return this.returnItemPermission;
    }
}

