/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.entryeditors.EntryEditorManager;
import org.apache.directory.studio.ldapbrowser.ui.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BrowserUIPlugin
extends AbstractUIPlugin {
    private static BrowserUIPlugin plugin;
    private EntryEditorManager entryEditorManager;
    private PropertyResourceBundle properties;

    public BrowserUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.entryEditorManager == null) {
            this.entryEditorManager = new EntryEditorManager();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.entryEditorManager != null) {
            this.entryEditorManager.dispose();
            this.entryEditorManager = null;
        }
        plugin = null;
    }

    public static BrowserUIPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = this.find((IPath)new Path(key));
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public EntryEditorManager getEntryEditorManager() {
        return this.entryEditorManager;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.ldapbrowser.ui", 0, Messages.getString("BrowserUIPlugin.UnableGetPluginProperties"), (Throwable)e));
            }
        }
        return this.properties;
    }
}

