/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BatchOperationFinishWizardPage
extends WizardPage {
    public static final String EXECUTE_METHOD_DIALOGSETTING_KEY = String.valueOf(BatchOperationFinishWizardPage.class.getName()) + ".executeMethod";
    public static final String CONTINUE_ON_ERROR_DIALOGSETTING_KEY = String.valueOf(BatchOperationFinishWizardPage.class.getName()) + ".continueOnError";
    public static final int EXECUTION_METHOD_NONE = -1;
    public static final int EXECUTION_METHOD_ON_CONNECTION = 0;
    public static final int EXECUTION_METHOD_LDIF_EDITOR = 1;
    public static final int EXECUTION_METHOD_LDIF_FILE = 2;
    public static final int EXECUTION_METHOD_LDIF_CLIPBOARD = 3;
    private Button executeOnConnectionButton;
    private Button continueOnErrorButton;
    private Button generateLdifButton;
    private Button generateInLDIFEditorButton;
    private Button generateInFileButton;
    private Button generateInClipboardButton;
    private SelectionListener validateSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BatchOperationFinishWizardPage.this.validate();
        }
    };

    public BatchOperationFinishWizardPage(String pageName) {
        super(pageName);
        super.setTitle(Messages.getString("BatchOperationFinishWizardPage.SelectExecutionMethod"));
        super.setDescription(Messages.getString("BatchOperationFinishWizardPage.PleaseSelectBatchOperation"));
        super.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.executeOnConnectionButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("BatchOperationFinishWizardPage.ExecuteOnConnection"), (int)1);
        Composite executeOnConnectionComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)executeOnConnectionComposite, (int)1);
        this.continueOnErrorButton = BaseWidgetUtils.createCheckbox((Composite)executeOnConnectionComposite, (String)Messages.getString("ImportLdifMainWizardPage.ContinueOnError"), (int)1);
        this.generateLdifButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("BatchOperationFinishWizardPage.GenerateLDIF"), (int)1);
        Composite generateLdifButtonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)generateLdifButtonComposite, (int)1);
        this.generateInLDIFEditorButton = BaseWidgetUtils.createRadiobutton((Composite)generateLdifButtonComposite, (String)Messages.getString("BatchOperationFinishWizardPage.GenerateLDIFInLDIFEditor"), (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)generateLdifButtonComposite, (int)1);
        this.generateInFileButton = BaseWidgetUtils.createRadiobutton((Composite)generateLdifButtonComposite, (String)Messages.getString("BatchOperationFinishWizardPage.GenerateLDIFInFile"), (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)generateLdifButtonComposite, (int)1);
        this.generateInClipboardButton = BaseWidgetUtils.createRadiobutton((Composite)generateLdifButtonComposite, (String)Messages.getString("BatchOperationFinishWizardPage.GenerateLDIFInClipBoard"), (int)1);
        this.init();
        this.validate();
        this.addListeners();
        this.setControl((Control)composite);
    }

    private void init() {
        try {
            if (BrowserUIPlugin.getDefault().getDialogSettings().get(EXECUTE_METHOD_DIALOGSETTING_KEY) == null) {
                BrowserUIPlugin.getDefault().getDialogSettings().put(EXECUTE_METHOD_DIALOGSETTING_KEY, 0);
            }
            if (BrowserUIPlugin.getDefault().getDialogSettings().get(CONTINUE_ON_ERROR_DIALOGSETTING_KEY) == null) {
                BrowserUIPlugin.getDefault().getDialogSettings().put(CONTINUE_ON_ERROR_DIALOGSETTING_KEY, true);
            }
            int executeMethod = BrowserUIPlugin.getDefault().getDialogSettings().getInt(EXECUTE_METHOD_DIALOGSETTING_KEY);
            switch (executeMethod) {
                case 0: {
                    this.executeOnConnectionButton.setSelection(true);
                    this.generateInLDIFEditorButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.generateLdifButton.setSelection(true);
                    this.generateInLDIFEditorButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.generateLdifButton.setSelection(true);
                    this.generateInFileButton.setSelection(true);
                    break;
                }
                case 3: {
                    this.generateLdifButton.setSelection(true);
                    this.generateInClipboardButton.setSelection(true);
                }
            }
            this.continueOnErrorButton.setSelection(BrowserUIPlugin.getDefault().getDialogSettings().getBoolean(CONTINUE_ON_ERROR_DIALOGSETTING_KEY));
        }
        catch (Exception exception) {}
    }

    private void validate() {
        this.continueOnErrorButton.setEnabled(this.executeOnConnectionButton.getSelection());
        this.generateInLDIFEditorButton.setEnabled(this.generateLdifButton.getSelection());
        this.generateInFileButton.setEnabled(this.generateLdifButton.getSelection());
        this.generateInClipboardButton.setEnabled(this.generateLdifButton.getSelection());
        this.setPageComplete(this.getExecutionMethod() != -1);
    }

    private void addListeners() {
        this.executeOnConnectionButton.addSelectionListener(this.validateSelectionListener);
        this.generateLdifButton.addSelectionListener(this.validateSelectionListener);
    }

    public int getExecutionMethod() {
        if (this.executeOnConnectionButton.getSelection()) {
            return 0;
        }
        if (this.generateLdifButton.getSelection()) {
            if (this.generateInLDIFEditorButton.getSelection()) {
                return 1;
            }
            if (this.generateInFileButton.getSelection()) {
                return 2;
            }
            if (this.generateInClipboardButton.getSelection()) {
                return 3;
            }
        }
        return -1;
    }

    public boolean getContinueOnError() {
        return this.continueOnErrorButton.getSelection();
    }

    public void saveDialogSettings() {
        BrowserUIPlugin.getDefault().getDialogSettings().put(EXECUTE_METHOD_DIALOGSETTING_KEY, this.getExecutionMethod());
        BrowserUIPlugin.getDefault().getDialogSettings().put(CONTINUE_ON_ERROR_DIALOGSETTING_KEY, this.getContinueOnError());
    }
}

