/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.fasterxml.jackson.databind.Module;
import com.google.inject.Binder;
import com.google.inject.Key;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.k8s.discovery.DefaultK8sApiClient;
import org.apache.druid.k8s.discovery.DefaultK8sLeaderElectorFactory;
import org.apache.druid.k8s.discovery.K8sApiClient;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sDruidLeaderSelectorProvider;
import org.apache.druid.k8s.discovery.K8sDruidNodeAnnouncer;
import org.apache.druid.k8s.discovery.K8sDruidNodeDiscoveryProvider;
import org.apache.druid.k8s.discovery.K8sLeaderElectorFactory;

public class K8sDiscoveryModule
implements DruidModule {
    private static final String K8S_KEY = "k8s";

    public List<? extends Module> getJacksonModules() {
        return Collections.emptyList();
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.discovery.k8s", K8sDiscoveryConfig.class);
        binder.bind(ApiClient.class).toProvider(() -> {
            try {
                return Config.defaultClient();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to create K8s ApiClient instance", ex);
            }
        }).in(LazySingleton.class);
        binder.bind(K8sApiClient.class).to(DefaultK8sApiClient.class).in(LazySingleton.class);
        binder.bind(K8sLeaderElectorFactory.class).to(DefaultK8sLeaderElectorFactory.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidNodeDiscoveryProvider.class)).addBinding((Object)K8S_KEY).to(K8sDruidNodeDiscoveryProvider.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidNodeAnnouncer.class)).addBinding((Object)K8S_KEY).to(K8sDruidNodeAnnouncer.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidLeaderSelector.class, Coordinator.class)).addBinding((Object)K8S_KEY).toProvider(K8sDruidLeaderSelectorProvider.K8sCoordinatorDruidLeaderSelectorProvider.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidLeaderSelector.class, IndexingService.class)).addBinding((Object)K8S_KEY).toProvider(K8sDruidLeaderSelectorProvider.K8sIndexingServiceDruidLeaderSelectorProvider.class).in(LazySingleton.class);
    }
}

