/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.builder.AbstractChildBuilder;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.aliases.UserAliasesSource;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.util.ArrayList;
import java.util.List;

public class UserAliasSourceBuilder<C>
extends AbstractChildBuilder<UserAliasesSource<C>, ParserMetadata<C>, ParserBuilder<C>> {
    public static final String DEFAULT_EXTENSION = ".config";
    private List<String> searchLocations = new ArrayList<String>();
    private String filename;
    private String prefix;
    private List<ResourceLocator> locators = new ArrayList<ResourceLocator>();

    public UserAliasSourceBuilder(ParserBuilder<C> parserBuilder) {
        super(parserBuilder);
    }

    public UserAliasSourceBuilder<C> withProgramName(String programName) {
        this.filename = programName + DEFAULT_EXTENSION;
        return this;
    }

    public UserAliasSourceBuilder<C> withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public UserAliasSourceBuilder<C> withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public UserAliasSourceBuilder<C> withDefaultLocators() {
        for (ResourceLocator locator : UserAliasesSource.DEFAULT_LOCATORS) {
            this.locators.add(locator);
        }
        return this;
    }

    public UserAliasSourceBuilder<C> withLocator(ResourceLocator locator) {
        this.locators.add(locator);
        return this;
    }

    public UserAliasSourceBuilder<C> withLocators(List<ResourceLocator> locators) {
        this.locators.addAll(locators);
        return this;
    }

    public UserAliasSourceBuilder<C> withLocators(ResourceLocator ... locators) {
        for (ResourceLocator locator : locators) {
            this.locators.add(locator);
        }
        return this;
    }

    public UserAliasSourceBuilder<C> withDefaultSearchLocation(String programName) {
        this.searchLocations.add("./," + programName + "/");
        return this;
    }

    public UserAliasSourceBuilder<C> withSearchLocation(String location) {
        this.searchLocations.add(location);
        return this;
    }

    public UserAliasSourceBuilder<C> withSearchLocations(String ... locations) {
        for (String loc : locations) {
            this.searchLocations.add(loc);
        }
        return this;
    }

    public boolean isBuildable() {
        return this.filename != null && !this.searchLocations.isEmpty();
    }

    @Override
    public UserAliasesSource<C> build() {
        if (this.filename == null) {
            throw new IllegalStateException("Must specify a configuration file to search for");
        }
        if (this.searchLocations.isEmpty()) {
            throw new IllegalStateException("Must specify at least one search location");
        }
        return new UserAliasesSource(this.filename, this.prefix, this.locators.size() > 0 ? this.locators : null, this.searchLocations);
    }
}

