/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protobuf.dynamic;

import com.github.os72.protobuf.dynamic.EnumDefinition;
import com.google.protobuf.DescriptorProtos;
import java.util.HashMap;
import java.util.Map;

public class MessageDefinition {
    private DescriptorProtos.DescriptorProto mMsgType;
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Type> sTypeMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Label> sLabelMap;

    public static Builder newBuilder(String msgTypeName) {
        return new Builder(msgTypeName);
    }

    public String toString() {
        return this.mMsgType.toString();
    }

    DescriptorProtos.DescriptorProto getMessageType() {
        return this.mMsgType;
    }

    private MessageDefinition(DescriptorProtos.DescriptorProto msgType) {
        this.mMsgType = msgType;
    }

    static {
        sTypeMap.put("double", DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        sTypeMap.put("float", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        sTypeMap.put("int32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        sTypeMap.put("int64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        sTypeMap.put("uint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
        sTypeMap.put("uint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
        sTypeMap.put("sint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
        sTypeMap.put("sint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
        sTypeMap.put("fixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
        sTypeMap.put("fixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
        sTypeMap.put("sfixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
        sTypeMap.put("sfixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
        sTypeMap.put("bool", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        sTypeMap.put("string", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        sTypeMap.put("bytes", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        sLabelMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Label>();
        sLabelMap.put("optional", DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
        sLabelMap.put("required", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        sLabelMap.put("repeated", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto.Builder mMsgTypeBuilder = DescriptorProtos.DescriptorProto.newBuilder();

        public Builder addField(String label, String type, String name, int num) {
            return this.addField(label, type, name, num, null);
        }

        public Builder addField(String label, String type, String name, int num, String defaultVal) {
            DescriptorProtos.FieldDescriptorProto.Label protoLabel = (DescriptorProtos.FieldDescriptorProto.Label)sLabelMap.get(label);
            if (protoLabel == null) {
                throw new IllegalArgumentException("Illegal label: " + label);
            }
            this.addField(protoLabel, type, name, num, defaultVal);
            return this;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mMsgTypeBuilder.addNestedType(msgDef.getMessageType());
            return this;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mMsgTypeBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public MessageDefinition build() {
            return new MessageDefinition(this.mMsgTypeBuilder.build());
        }

        private Builder(String msgTypeName) {
            this.mMsgTypeBuilder.setName(msgTypeName);
        }

        private void addField(DescriptorProtos.FieldDescriptorProto.Label label, String type, String name, int num, String defaultVal) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldBuilder.setLabel(label);
            DescriptorProtos.FieldDescriptorProto.Type primType = (DescriptorProtos.FieldDescriptorProto.Type)sTypeMap.get(type);
            if (primType != null) {
                fieldBuilder.setType(primType);
            } else {
                fieldBuilder.setTypeName(type);
            }
            fieldBuilder.setName(name).setNumber(num);
            if (defaultVal != null) {
                fieldBuilder.setDefaultValue(defaultVal);
            }
            this.mMsgTypeBuilder.addField(fieldBuilder.build());
        }
    }
}

