/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.facade;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.facade.TableFacade;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.column.ColumnType;

public class DatasourceFacade
extends TableFacade {
    private static final Logger LOG = new Logger(DatasourceFacade.class);
    private final List<ColumnFacade> columns;
    private final Map<String, ColumnFacade> columnIndex;

    public DatasourceFacade(ResolvedTable resolved) {
        super(resolved);
        this.columns = resolved.spec().columns().stream().map(col -> new ColumnFacade((ColumnSpec)col)).collect(Collectors.toList());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnFacade col2 : this.columns) {
            builder.put((Object)col2.spec.name(), (Object)col2);
        }
        this.columnIndex = builder.build();
    }

    public String segmentGranularityString() {
        return this.stringProperty("segmentGranularity");
    }

    @Nullable
    public Granularity segmentGranularity() {
        String definedGranularity = this.segmentGranularityString();
        return definedGranularity == null ? null : CatalogUtils.asDruidGranularity(definedGranularity);
    }

    public Integer targetSegmentRows() {
        return this.intProperty("targetSegmentRows");
    }

    public List<ClusterKeySpec> clusterKeys() {
        Object value = this.property("clusterKeys");
        if (value == null) {
            return Collections.emptyList();
        }
        try {
            return (List)this.jsonMapper().convertValue(value, ClusterKeySpec.CLUSTER_KEY_LIST_TYPE_REF);
        }
        catch (Exception e) {
            LOG.error("Failed to convert a catalog %s property of value [%s]", new Object[]{"clusterKeys", value});
            return Collections.emptyList();
        }
    }

    public List<String> hiddenColumns() {
        Object value = this.property("hiddenColumns");
        return value == null ? Collections.emptyList() : (List)value;
    }

    public boolean isSealed() {
        return this.booleanProperty("sealed");
    }

    public List<ColumnFacade> columnFacades() {
        return this.columns;
    }

    public ColumnFacade column(String name) {
        return this.columnIndex.get(name);
    }

    public static class ColumnFacade {
        private final ColumnSpec spec;
        private final String sqlType;

        public ColumnFacade(ColumnSpec spec) {
            this.spec = spec;
            this.sqlType = Columns.isTimeColumn(spec.name()) && spec.dataType() == null ? Columns.LONG : Columns.sqlType(spec);
        }

        public ColumnSpec spec() {
            return this.spec;
        }

        public boolean hasType() {
            return this.sqlType != null;
        }

        public boolean isTime() {
            return Columns.isTimeColumn(this.spec.name());
        }

        public ColumnType druidType() {
            return Columns.druidType(this.spec);
        }

        public String sqlStorageType() {
            return this.sqlType;
        }

        public String toString() {
            return "{spec=" + this.spec + ", sqlTtype=" + this.sqlType + "}";
        }

        public static enum Kind {
            ANY,
            TIME,
            DIMENSION,
            MEASURE;

        }
    }
}

