/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.utils.CollectionUtils;

public class DataSourcesSnapshot {
    private final Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments;
    private final Map<String, SegmentTimeline> usedSegmentsTimelinesPerDataSource;
    private final ImmutableSet<DataSegment> overshadowedSegments;

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments, ImmutableMap<String, String> dataSourceProperties) {
        HashMap dataSources = new HashMap();
        segments.forEach(segment -> dataSources.computeIfAbsent(segment.getDataSource(), dsName -> new DruidDataSource((String)dsName, (Map<String, String>)dataSourceProperties)).addSegmentIfAbsent((DataSegment)segment));
        return new DataSourcesSnapshot(CollectionUtils.mapValues(dataSources, DruidDataSource::toImmutableDruidDataSource));
    }

    public DataSourcesSnapshot(Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments) {
        this(dataSourcesWithAllUsedSegments, CollectionUtils.mapValues(dataSourcesWithAllUsedSegments, dataSource -> SegmentTimeline.forSegments(dataSource.getSegments())));
    }

    private DataSourcesSnapshot(Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments, Map<String, SegmentTimeline> usedSegmentsTimelinesPerDataSource) {
        this.dataSourcesWithAllUsedSegments = dataSourcesWithAllUsedSegments;
        this.usedSegmentsTimelinesPerDataSource = usedSegmentsTimelinesPerDataSource;
        this.overshadowedSegments = ImmutableSet.copyOf(this.determineOvershadowedSegments());
    }

    public Collection<ImmutableDruidDataSource> getDataSourcesWithAllUsedSegments() {
        return this.dataSourcesWithAllUsedSegments.values();
    }

    public Map<String, ImmutableDruidDataSource> getDataSourcesMap() {
        return this.dataSourcesWithAllUsedSegments;
    }

    @Nullable
    public ImmutableDruidDataSource getDataSource(String dataSourceName) {
        return this.dataSourcesWithAllUsedSegments.get(dataSourceName);
    }

    public Map<String, SegmentTimeline> getUsedSegmentsTimelinesPerDataSource() {
        return this.usedSegmentsTimelinesPerDataSource;
    }

    public ImmutableSet<DataSegment> getOvershadowedSegments() {
        return this.overshadowedSegments;
    }

    public Iterable<DataSegment> iterateAllUsedSegmentsInSnapshot() {
        return () -> this.dataSourcesWithAllUsedSegments.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    private List<DataSegment> determineOvershadowedSegments() {
        ArrayList<DataSegment> overshadowedSegments = new ArrayList<DataSegment>();
        for (ImmutableDruidDataSource dataSource : this.dataSourcesWithAllUsedSegments.values()) {
            SegmentTimeline usedSegmentsTimeline = this.usedSegmentsTimelinesPerDataSource.get(dataSource.getName());
            for (DataSegment segment : dataSource.getSegments()) {
                if (!usedSegmentsTimeline.isOvershadowed(segment)) continue;
                overshadowedSegments.add(segment);
            }
        }
        return overshadowedSegments;
    }
}

