/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheProvider;
import org.apache.druid.client.cache.HybridCache;
import org.apache.druid.client.cache.HybridCacheConfig;

public class HybridCacheProvider
extends HybridCacheConfig
implements CacheProvider {
    final CacheProvider level1;
    final CacheProvider level2;

    @JsonCreator
    public HybridCacheProvider(@JacksonInject @Named(value="l1") CacheProvider level1, @JacksonInject @Named(value="l2") CacheProvider level2) {
        this.level1 = (CacheProvider)Preconditions.checkNotNull((Object)level1, (Object)"l1 cache not specified for hybrid cache");
        this.level2 = (CacheProvider)Preconditions.checkNotNull((Object)level2, (Object)"l2 cache not specified for hybrid cache");
        if (!this.getUseL2() && !this.getPopulateL2()) {
            throw new IllegalStateException("Doesn't make sense to use Hybrid cache with both use and populate disabled for L2, use just L1 cache in this case");
        }
    }

    public Cache get() {
        return new HybridCache(this, (Cache)this.level1.get(), (Cache)this.level2.get());
    }
}

