/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.druid.client.selector.AbstractTierSelectorStrategy;
import org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.druid.client.selector.ServerSelectorStrategy;

public class CustomTierSelectorStrategy
extends AbstractTierSelectorStrategy {
    private final Comparator<Integer> comparator;

    @JsonCreator
    public CustomTierSelectorStrategy(@JacksonInject ServerSelectorStrategy serverSelectorStrategy, @JacksonInject CustomTierSelectorStrategyConfig config) {
        super(serverSelectorStrategy);
        HashMap<Integer, Integer> lookup = new HashMap<Integer, Integer>();
        int pos = 0;
        for (Integer integer : config.getPriorities()) {
            lookup.put(integer, pos);
            ++pos;
        }
        this.comparator = (p1, p2) -> {
            if (lookup.containsKey(p1) && lookup.containsKey(p2)) {
                return Integer.compare((Integer)lookup.get(p1), (Integer)lookup.get(p2));
            }
            if (lookup.containsKey(p1)) {
                return -1;
            }
            if (lookup.containsKey(p2)) {
                return 1;
            }
            return Integer.compare(p2, p1);
        };
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this.comparator;
    }
}

