/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.join.BroadcastTableJoinableFactory;
import org.apache.druid.segment.join.FrameBasedInlineJoinableFactory;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;

public class JoinableFactoryModule
implements Module {
    @VisibleForTesting
    static final Map<Class<? extends DataSource>, Class<? extends JoinableFactory>> FACTORY_MAPPINGS = ImmutableMap.of(InlineDataSource.class, InlineJoinableFactory.class, FrameBasedInlineDataSource.class, FrameBasedInlineJoinableFactory.class, LookupDataSource.class, LookupJoinableFactory.class, GlobalTableDataSource.class, BroadcastTableJoinableFactory.class);

    public void configure(Binder binder) {
        MapBinder<Class<? extends JoinableFactory>, Class<? extends DataSource>> joinableFactoryMappingBinder = DruidBinders.joinableMappingBinder(binder);
        Multibinder<JoinableFactory> joinableFactoryMultibinder = DruidBinders.joinableFactoryMultiBinder(binder);
        FACTORY_MAPPINGS.forEach((ds, factory) -> {
            joinableFactoryMultibinder.addBinding().to(factory);
            joinableFactoryMappingBinder.addBinding(factory).toInstance(ds);
            binder.bind(factory).in(LazySingleton.class);
        });
        binder.bind(JoinableFactory.class).to(MapJoinableFactory.class).in(Scopes.SINGLETON);
    }
}

