/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.TaskIdentifier;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataStorageActionHandler;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.metadata.PasswordProviderRedactionMixIn;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public abstract class SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
implements MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataStorageActionHandler.class);
    private static final String CONTEXT_KEY_IS_TRANSIENT = "isTransient";
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final TypeReference<EntryType> entryType;
    private final TypeReference<StatusType> statusType;
    private final TypeReference<LockType> lockType;
    private final String entryTypeName;
    private final String entryTable;
    private final String lockTable;
    private final TaskInfoMapper<EntryType, StatusType> taskInfoMapper;
    private final TaskStatusMapper taskStatusMapper;
    private final TaskStatusMapperFromPayload taskStatusMapperFromPayload;
    private final TaskIdentifierMapper taskIdentifierMapper;
    private Future<Boolean> taskMigrationCompleteFuture;

    @Deprecated
    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        this(connector, jsonMapper, types, entryTypeName, entryTable, lockTable);
    }

    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String lockTable) {
        this.connector = connector;
        this.jsonMapper = jsonMapper.copy().addMixIn(PasswordProvider.class, PasswordProviderRedactionMixIn.class);
        this.entryType = types.getEntryType();
        this.statusType = types.getStatusType();
        this.lockType = types.getLockType();
        this.entryTypeName = entryTypeName;
        this.entryTable = entryTable;
        this.lockTable = lockTable;
        this.taskInfoMapper = new TaskInfoMapper<EntryType, StatusType>(jsonMapper, this.entryType, this.statusType);
        this.taskStatusMapper = new TaskStatusMapper(jsonMapper);
        this.taskStatusMapperFromPayload = new TaskStatusMapperFromPayload(jsonMapper);
        this.taskIdentifierMapper = new TaskIdentifierMapper(jsonMapper);
    }

    protected SQLMetadataConnector getConnector() {
        return this.connector;
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    protected TypeReference<StatusType> getStatusType() {
        return this.statusType;
    }

    protected String getEntryTable() {
        return this.entryTable;
    }

    protected String getLogTable() {
        throw new UnsupportedOperationException("'tasklogs' table is not used anymore");
    }

    protected String getEntryTypeName() {
        return this.entryTypeName;
    }

    public TypeReference<EntryType> getEntryType() {
        return this.entryType;
    }

    public void insert(String id, DateTime timestamp, String dataSource, EntryType entry, boolean active, StatusType status, String type, String groupId) {
        try {
            this.getConnector().retryWithHandle(handle -> this.insertEntryWithHandle(handle, id, timestamp, dataSource, entry, active, status, type, groupId), (Predicate<Throwable>)((Predicate)this::isTransientDruidException));
        }
        catch (CallbackFailedException e) {
            this.propagateAsRuntimeException(e.getCause());
        }
        catch (Exception e) {
            this.propagateAsRuntimeException(e);
        }
    }

    private void propagateAsRuntimeException(Throwable t) {
        Throwables.propagateIfPossible((Throwable)t);
        throw new RuntimeException(t);
    }

    private Void insertEntryWithHandle(Handle handle, String entryId, DateTime timestamp, String dataSource, EntryType entry, boolean active, StatusType status, String type, String groupId) {
        try {
            String sql = StringUtils.format((String)"INSERT INTO %s (id, created_date, datasource, payload, type, group_id, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :type, :group_id, :active, :status_payload)", (Object[])new Object[]{this.getEntryTable()});
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(sql).bind("id", entryId)).bind("created_date", timestamp.toString())).bind("datasource", dataSource)).bind("payload", this.jsonMapper.writeValueAsBytes(entry))).bind("type", type)).bind("group_id", groupId)).bind("active", active)).bind("status_payload", this.jsonMapper.writeValueAsBytes(status))).execute();
            return null;
        }
        catch (Throwable t) {
            throw this.wrapInDruidException(entryId, t);
        }
    }

    public static boolean isStatementException(Throwable e) {
        return e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
    }

    private boolean isTransientDruidException(Throwable t) {
        if (t instanceof CallbackFailedException) {
            return this.isTransientDruidException(t.getCause());
        }
        if (t instanceof DruidException) {
            return Boolean.parseBoolean(((DruidException)t).getContextValue(CONTEXT_KEY_IS_TRANSIENT));
        }
        return this.getConnector().isTransientException(t);
    }

    public boolean setStatus(final String entryId, final boolean active, final StatusType status) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = TRUE", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute() == 1;
            }
        });
    }

    public Optional<EntryType> getEntry(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<EntryType>>(){

            public Optional<EntryType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE id = :id", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.entryType));
            }
        });
    }

    public Optional<StatusType> getStatus(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<StatusType>>(){

            public Optional<StatusType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(StringUtils.format((String)"SELECT status_payload FROM %s WHERE id = :id", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.statusType));
            }
        });
    }

    @Nullable
    public TaskInfo<EntryType, StatusType> getTaskInfo(String entryId) {
        return (TaskInfo)this.connector.retryWithHandle(handle -> {
            String query = StringUtils.format((String)"SELECT id, status_payload, payload, datasource, created_date FROM %s WHERE id = :id", (Object[])new Object[]{this.entryTable});
            return (TaskInfo)((Query)handle.createQuery(query).bind("id", entryId)).map(this.taskInfoMapper).first();
        });
    }

    public List<TaskInfo<EntryType, StatusType>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String dataSource) {
        return (List)this.getConnector().retryTransaction((handle, status) -> {
            ArrayList tasks = new ArrayList();
            block4: for (Map.Entry entry : taskLookups.entrySet()) {
                switch ((TaskLookup.TaskLookupType)entry.getKey()) {
                    case ACTIVE: {
                        Query<Map<String, Object>> query = this.createActiveTaskStreamingQuery(handle, dataSource);
                        tasks.addAll(query.map(this.taskInfoMapper).list());
                        continue block4;
                    }
                    case COMPLETE: {
                        TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)entry.getValue();
                        Query<Map<String, Object>> query = this.createCompletedTaskStreamingQuery(handle, completeTaskLookup.getTasksCreatedPriorTo(), completeTaskLookup.getMaxTaskStatuses(), dataSource);
                        tasks.addAll(query.map(this.taskInfoMapper).list());
                        continue block4;
                    }
                }
                throw new IAE("Unknown TaskLookupType: [%s]", new Object[]{entry.getKey()});
            }
            return tasks;
        }, 3, 10);
    }

    public List<TaskInfo<TaskIdentifier, StatusType>> getTaskStatusList(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String dataSource) {
        boolean fetchPayload = true;
        if (this.taskMigrationCompleteFuture != null && this.taskMigrationCompleteFuture.isDone()) {
            try {
                fetchPayload = this.taskMigrationCompleteFuture.get() == false;
            }
            catch (Exception e) {
                log.info((Throwable)e, "Exception getting task migration future", new Object[0]);
            }
        }
        return this.getTaskStatusList(taskLookups, dataSource, fetchPayload);
    }

    @VisibleForTesting
    List<TaskInfo<TaskIdentifier, StatusType>> getTaskStatusList(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String dataSource, boolean fetchPayload) {
        Object resultSetMapper = fetchPayload ? this.taskStatusMapperFromPayload : this.taskStatusMapper;
        return (List)this.getConnector().retryTransaction((arg_0, arg_1) -> this.lambda$getTaskStatusList$3(taskLookups, fetchPayload, dataSource, (ResultSetMapper)resultSetMapper, arg_0, arg_1), 3, 10);
    }

    private DruidException wrapInDruidException(String taskId, Throwable t) {
        if (SQLMetadataStorageActionHandler.isStatementException(t) && this.getEntry(taskId).isPresent()) {
            return InvalidInput.exception((String)"Task [%s] already exists", (Object[])new Object[]{taskId});
        }
        if (this.connector.isRootCausePacketTooBigException(t)) {
            return InvalidInput.exception((String)"Payload for task [%s] exceeds the max allowed packet limit. If you encountered this error while running native batch ingestion, set a 'splitHintSpec' to reduce the payload of each task. If not running native batch ingestion, report this error to your operator.", (Object[])new Object[]{taskId});
        }
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(t, "Encountered metadata exception for task [%s]", new Object[]{taskId}).withContext(CONTEXT_KEY_IS_TRANSIENT, (Object)this.connector.isTransientException(t));
    }

    private Query<Map<String, Object>> createCompletedTaskSummaryStreamingQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   created_date,   datasource,   group_id,   type,   status_payload FROM   %s WHERE " + this.getWhereClauseForInactiveStatusesSinceQuery(dataSource) + "ORDER BY created_date DESC"), (Object[])new Object[]{this.getEntryTable()});
        if (maxNumStatuses != null) {
            sql = this.decorateSqlWithLimit(sql);
        }
        Query query = ((Query)handle.createQuery(sql).bind("start", timestamp.toString())).setFetchSize(this.connector.getStreamingFetchSize());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private Query<Map<String, Object>> createCompletedTaskStreamingQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   status_payload,   created_date,   datasource,   payload FROM   %s WHERE " + this.getWhereClauseForInactiveStatusesSinceQuery(dataSource) + "ORDER BY created_date DESC"), (Object[])new Object[]{this.getEntryTable()});
        if (maxNumStatuses != null) {
            sql = this.decorateSqlWithLimit(sql);
        }
        Query query = ((Query)handle.createQuery(sql).bind("start", timestamp.toString())).setFetchSize(this.connector.getStreamingFetchSize());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    protected abstract String decorateSqlWithLimit(String var1);

    private String getWhereClauseForInactiveStatusesSinceQuery(@Nullable String datasource) {
        String sql = StringUtils.format((String)"active = FALSE AND created_date >= :start ", (Object[])new Object[0]);
        if (datasource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    private Query<Map<String, Object>> createActiveTaskSummaryStreamingQuery(Handle handle, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   status_payload,   group_id,   type,   datasource,   created_date FROM   %s WHERE " + this.getWhereClauseForActiveStatusesQuery(dataSource) + "ORDER BY created_date"), (Object[])new Object[]{this.entryTable});
        Query query = handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize());
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private Query<Map<String, Object>> createActiveTaskStreamingQuery(Handle handle, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   status_payload,   payload,   datasource,   created_date FROM   %s WHERE " + this.getWhereClauseForActiveStatusesQuery(dataSource) + "ORDER BY created_date"), (Object[])new Object[]{this.entryTable});
        Query query = handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize());
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private String getWhereClauseForActiveStatusesQuery(String dataSource) {
        String sql = StringUtils.format((String)"active = TRUE ", (Object[])new Object[0]);
        if (dataSource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    private TaskInfo<TaskIdentifier, StatusType> toTaskIdentifierInfo(ObjectMapper objectMapper, ResultSet resultSet, boolean usePayload) throws SQLException {
        Object status;
        String groupId;
        String type;
        if (usePayload) {
            try {
                ObjectNode payload = (ObjectNode)objectMapper.readValue(resultSet.getBytes("payload"), ObjectNode.class);
                type = payload.get("type").asText();
                groupId = payload.get("groupId").asText();
            }
            catch (IOException e) {
                log.error((Throwable)e, "Encountered exception while deserializing task payload", new Object[0]);
                throw new SQLException(e);
            }
        } else {
            type = resultSet.getString("type");
            groupId = resultSet.getString("group_id");
        }
        String id = resultSet.getString("id");
        DateTime createdTime = DateTimes.of((String)resultSet.getString("created_date"));
        try {
            status = objectMapper.readValue(resultSet.getBytes("status_payload"), this.statusType);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Encountered exception while deserializing task status_payload", new Object[0]);
            throw new SQLException(e);
        }
        String datasource = resultSet.getString("datasource");
        TaskIdentifier taskIdentifier = new TaskIdentifier(id, groupId, type);
        return new TaskInfo(id, createdTime, status, datasource, (Object)taskIdentifier);
    }

    public boolean addLock(final String entryId, final LockType lock) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return SQLMetadataStorageActionHandler.this.addLock(handle, entryId, lock);
            }
        });
    }

    private boolean addLock(Handle handle, String entryId, LockType lock) throws JsonProcessingException {
        String statement = StringUtils.format((String)"INSERT INTO %1$s (%2$s_id, lock_payload) VALUES (:entryId, :payload)", (Object[])new Object[]{this.lockTable, this.entryTypeName});
        return ((Update)((Update)handle.createStatement(statement).bind("entryId", entryId)).bind("payload", this.jsonMapper.writeValueAsBytes(lock))).execute() == 1;
    }

    public boolean replaceLock(String entryId, long oldLockId, LockType newLock) {
        return (Boolean)this.connector.retryTransaction((handle, transactionStatus) -> {
            int numDeletedRows = this.removeLock(handle, oldLockId);
            if (numDeletedRows != 1) {
                transactionStatus.setRollbackOnly();
                String message = numDeletedRows == 0 ? StringUtils.format((String)"Cannot find lock[%d]", (Object[])new Object[]{oldLockId}) : StringUtils.format((String)"Found multiple locks for lockId[%d]", (Object[])new Object[]{oldLockId});
                throw new RuntimeException(message);
            }
            return this.addLock(handle, entryId, newLock);
        }, 3, 10);
    }

    public void removeLock(final long lockId) {
        this.connector.retryWithHandle(new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                SQLMetadataStorageActionHandler.this.removeLock(handle, lockId);
                return null;
            }
        });
    }

    public void removeTasksOlderThan(long timestamp) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        this.connector.retryWithHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE created_date < :date_time AND active = false", (Object[])new Object[]{this.entryTable})).bind("date_time", dateTime.toString())).execute());
    }

    private int removeLock(Handle handle, long lockId) {
        return ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE id = :id", (Object[])new Object[]{this.lockTable})).bind("id", lockId)).execute();
    }

    public Map<Long, LockType> getLocks(final String entryId) {
        return (Map)this.connector.retryWithHandle(new HandleCallback<Map<Long, LockType>>(){

            public Map<Long, LockType> withHandle(Handle handle) {
                return (Map)((Query)handle.createQuery(StringUtils.format((String)"SELECT id, lock_payload FROM %1$s WHERE %2$s_id = :entryId", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName})).bind("entryId", entryId)).map(new ResultSetMapper<Pair<Long, LockType>>(){

                    public Pair<Long, LockType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of((Object)r.getLong("id"), (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("lock_payload"), SQLMetadataStorageActionHandler.this.lockType));
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to deserialize " + SQLMetadataStorageActionHandler.this.lockType.getType(), new Object[0]).addData("id", (Object)r.getLong("id")).addData("lockPayload", (Object)StringUtils.fromUtf8((byte[])r.getBytes("lock_payload"))).emit();
                            throw new SQLException(e);
                        }
                    }
                }).fold((Object)Maps.newLinkedHashMap(), new Folder3<Map<Long, LockType>, Pair<Long, LockType>>(){

                    public Map<Long, LockType> fold(Map<Long, LockType> accumulator, Pair<Long, LockType> lock, FoldController control, StatementContext ctx) {
                        accumulator.put((Long)lock.lhs, lock.rhs);
                        return accumulator;
                    }
                });
            }
        });
    }

    @Nullable
    public Long getLockId(String entryId, LockType lock) {
        return this.getLocks(entryId).entrySet().stream().filter(entry -> entry.getValue().equals(lock)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    private List<TaskIdentifier> fetchTasksWithTypeColumnNullAndIdGreaterThan(String id, int limit) {
        ArrayList<TaskIdentifier> taskIdentifiers = new ArrayList<TaskIdentifier>();
        this.connector.retryWithHandle(handle -> {
            String sql = StringUtils.format((String)"SELECT * FROM %1$s WHERE id > '%2$s' AND type IS null ORDER BY id %3$s", (Object[])new Object[]{this.entryTable, id, this.connector.limitClause(limit)});
            Query query = handle.createQuery(sql);
            taskIdentifiers.addAll(query.map((ResultSetMapper)this.taskIdentifierMapper).list());
            return null;
        });
        return taskIdentifiers;
    }

    private int updateColumnsTypeAndGroupIdForTasks(List<TaskIdentifier> taskIdentifiers) {
        return (Integer)this.connector.retryWithHandle(handle -> {
            Batch batch = handle.createBatch();
            for (TaskIdentifier task : taskIdentifiers) {
                batch.add(StringUtils.format((String)"UPDATE %1$s SET type = '%2$s', group_id = '%3$s' WHERE id = '%4$s'", (Object[])new Object[]{this.entryTable, task.getType(), task.getGroupId(), task.getId()}));
            }
            int[] result = batch.execute();
            return IntStream.of(result).sum();
        });
    }

    public void populateTaskTypeAndGroupIdAsync() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.taskMigrationCompleteFuture = executorService.submit(this::populateTaskTypeAndGroupId);
    }

    @VisibleForTesting
    boolean populateTaskTypeAndGroupId() {
        log.debug("Populating columns [task] and [group_id] in task table[%s] from payload.", new Object[]{this.entryTable});
        String lastUpdatedTaskId = "";
        int limit = 100;
        int numUpdatedTasks = 0;
        while (true) {
            List<TaskIdentifier> taskIdentifiers;
            try {
                taskIdentifiers = this.fetchTasksWithTypeColumnNullAndIdGreaterThan(lastUpdatedTaskId, 100);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Task migration failed while reading entries from task table", new Object[0]);
                return false;
            }
            if (taskIdentifiers.isEmpty()) break;
            try {
                int updatedCount = this.updateColumnsTypeAndGroupIdForTasks(taskIdentifiers);
                if (updatedCount > 0) {
                    log.info("Successfully updated columns [type] and [group_id] for [%d] tasks.", new Object[]{numUpdatedTasks += updatedCount});
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Task migration failed while updating entries in task table", new Object[0]);
                return false;
            }
            lastUpdatedTaskId = taskIdentifiers.get(taskIdentifiers.size() - 1).getId();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.info("Interrupted, exiting!", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
        if (numUpdatedTasks > 0) {
            log.info("Task migration for table[%s] successful.", new Object[]{this.entryTable});
        }
        return true;
    }

    private /* synthetic */ List lambda$getTaskStatusList$3(Map taskLookups, boolean fetchPayload, String dataSource, ResultSetMapper resultSetMapper, Handle handle, TransactionStatus status) throws Exception {
        ArrayList taskMetadataInfos = new ArrayList();
        block4: for (Map.Entry entry : taskLookups.entrySet()) {
            switch ((TaskLookup.TaskLookupType)entry.getKey()) {
                case ACTIVE: {
                    Query<Map<String, Object>> query = fetchPayload ? this.createActiveTaskStreamingQuery(handle, dataSource) : this.createActiveTaskSummaryStreamingQuery(handle, dataSource);
                    taskMetadataInfos.addAll(query.map(resultSetMapper).list());
                    continue block4;
                }
                case COMPLETE: {
                    TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)entry.getValue();
                    DateTime priorTo = completeTaskLookup.getTasksCreatedPriorTo();
                    Integer limit = completeTaskLookup.getMaxTaskStatuses();
                    Query<Map<String, Object>> query = fetchPayload ? this.createCompletedTaskStreamingQuery(handle, priorTo, limit, dataSource) : this.createCompletedTaskSummaryStreamingQuery(handle, priorTo, limit, dataSource);
                    taskMetadataInfos.addAll(query.map(resultSetMapper).list());
                    continue block4;
                }
            }
            throw new IAE("Unknown TaskLookupType: [%s]", new Object[]{entry.getKey()});
        }
        return taskMetadataInfos;
    }

    static class TaskInfoMapper<EntryType, StatusType>
    implements ResultSetMapper<TaskInfo<EntryType, StatusType>> {
        private final ObjectMapper objectMapper;
        private final TypeReference<EntryType> entryType;
        private final TypeReference<StatusType> statusType;

        TaskInfoMapper(ObjectMapper objectMapper, TypeReference<EntryType> entryType, TypeReference<StatusType> statusType) {
            this.objectMapper = objectMapper;
            this.entryType = entryType;
            this.statusType = statusType;
        }

        public TaskInfo<EntryType, StatusType> map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            Object status;
            Object task;
            try {
                task = this.objectMapper.readValue(resultSet.getBytes("payload"), this.entryType);
            }
            catch (IOException e) {
                log.warn("Encountered exception[%s] while deserializing task payload, setting payload to null", new Object[]{e.getMessage()});
                task = null;
            }
            try {
                status = this.objectMapper.readValue(resultSet.getBytes("status_payload"), this.statusType);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Encountered exception while deserializing task status_payload", new Object[0]);
                throw new SQLException(e);
            }
            TaskInfo taskInfo = new TaskInfo(resultSet.getString("id"), DateTimes.of((String)resultSet.getString("created_date")), status, resultSet.getString("datasource"), task);
            return taskInfo;
        }
    }

    static class TaskIdentifierMapper
    implements ResultSetMapper<TaskIdentifier> {
        private final ObjectMapper objectMapper;

        TaskIdentifierMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public TaskIdentifier map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            try {
                ObjectNode payload = (ObjectNode)this.objectMapper.readValue(resultSet.getBytes("payload"), ObjectNode.class);
                JsonNode type = payload.get("type");
                JsonNode groupId = payload.get("groupId");
                return new TaskIdentifier(resultSet.getString("id"), groupId == null ? "" : groupId.asText(), type == null ? "" : type.asText());
            }
            catch (IOException e) {
                log.error((Throwable)e, "Encountered exception while deserializing task payload", new Object[0]);
                throw new SQLException(e);
            }
        }
    }

    private class TaskStatusMapper
    implements ResultSetMapper<TaskInfo<TaskIdentifier, StatusType>> {
        private final ObjectMapper objectMapper;

        TaskStatusMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public TaskInfo<TaskIdentifier, StatusType> map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            return SQLMetadataStorageActionHandler.this.toTaskIdentifierInfo(this.objectMapper, resultSet, false);
        }
    }

    private class TaskStatusMapperFromPayload
    implements ResultSetMapper<TaskInfo<TaskIdentifier, StatusType>> {
        private final ObjectMapper objectMapper;

        TaskStatusMapperFromPayload(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public TaskInfo<TaskIdentifier, StatusType> map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            return SQLMetadataStorageActionHandler.this.toTaskIdentifierInfo(this.objectMapper, resultSet, true);
        }
    }
}

