/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public interface SegmentsMetadataManager {
    public void startPollingDatabasePeriodically();

    public void stopPollingDatabasePeriodically();

    public boolean isPollingDatabasePeriodically();

    public int markAsUsedAllNonOvershadowedSegmentsInDataSource(String var1);

    public int markAsUsedNonOvershadowedSegmentsInInterval(String var1, Interval var2, @Nullable List<String> var3);

    public int markAsUsedNonOvershadowedSegments(String var1, Set<String> var2);

    public boolean markSegmentAsUsed(String var1);

    public int markAsUnusedAllSegmentsInDataSource(String var1);

    public int markAsUnusedSegmentsInInterval(String var1, Interval var2, @Nullable List<String> var3);

    public int markSegmentsAsUnused(Set<SegmentId> var1);

    public boolean markSegmentAsUnused(SegmentId var1);

    @Nullable
    public ImmutableDruidDataSource getImmutableDataSourceWithUsedSegments(String var1);

    public Collection<ImmutableDruidDataSource> getImmutableDataSourcesWithAllUsedSegments();

    public DataSourcesSnapshot getSnapshotOfDataSourcesWithAllUsedSegments();

    public Iterable<DataSegment> iterateAllUsedSegments();

    public Optional<Iterable<DataSegment>> iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(String var1, Interval var2, boolean var3);

    public Iterable<DataSegmentPlus> iterateAllUnusedSegmentsForDatasource(String var1, @Nullable Interval var2, @Nullable Integer var3, @Nullable String var4, @Nullable SortOrder var5);

    public Set<String> retrieveAllDataSourceNames();

    public List<Interval> getUnusedSegmentIntervals(String var1, @Nullable DateTime var2, DateTime var3, int var4, DateTime var5);

    public void populateUsedFlagLastUpdatedAsync();

    public void stopAsyncUsedFlagLastUpdatedUpdate();
}

