/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.joda.time.Interval;

public class LookupSegmentWrangler
implements SegmentWrangler {
    private final LookupExtractorFactoryContainerProvider lookupProvider;

    @Inject
    public LookupSegmentWrangler(LookupExtractorFactoryContainerProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public Iterable<Segment> getSegmentsForIntervals(DataSource dataSource, Iterable<Interval> intervals) {
        LookupDataSource lookupDataSource = (LookupDataSource)dataSource;
        Optional maybeContainer = this.lookupProvider.get(lookupDataSource.getLookupName());
        return maybeContainer.map(container -> Collections.singletonList(new LookupSegment(lookupDataSource.getLookupName(), container.getLookupExtractorFactory()))).orElse(Collections.emptyList());
    }
}

